//***************************************************************************
//
// Headerfile: CCexceptions.h
//
// Autor: A. Kipp
// erstellt: Thu Jan 19 17:43:21 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CCEXCEPTIONS
#define CCEXCEPTIONS

#include <stdio.h>
#include <string.h>

struct Ausnahme;

#ifdef SUN
#define failure(file,line,format,args...) \
  Ausnahme a(file,line);\
  sprintf(a.message,format,##args);\
  throw a;
#define assert( cond ) \
  if( !(cond) ) { Ausnahme a(__FILE__,__LINE__);\
                sprintf(a.message,"Assertion failed");\
                throw a; }
#endif

#ifdef LINUX
#define failure(file,line,format,args...) \
  fprintf(stderr,"File: %s, Line %d\n",file,line);\
  fprintf(stderr,format,##args);\
  putchar('\n');\
  exit(1);
#define assert( cond ) \
  if( !cond ) {fprintf(stderr,"%s %d: Assertion failed\n",__FILE__,__LINE);\
               exit(1);}
#endif

#ifdef WARNSTR
#define warning(file,line,format,args...) \
  sprintf(warnstr,format,##args);
#else
#define warning(file,line,format,args...) \
  fprintf(stderr,"File: %s, Line %d\n",file,line);\
  fprintf(stderr,format,##args);\
  putchar('\n');
#endif


#define OUT_OF_MEM_AUSN 1
#define CONSTRUCTION_FAILED 2
#define USER_AUSN 0


//***************************************************************************
// Klassendeklaration: class CCexceptions
//
// Autor: A. Kipp
// erstellt: Thu Jan 19 17:43:21 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
struct Ausnahme
  {
  Ausnahme()
    {
    file[0] = '\0';
    line = -1;
    message[0] = '\0';
    code = USER_AUSN;
    };
    
  // user-Ausnahmen
  Ausnahme(char* fil,int lin=-1,int cde=USER_AUSN)
    {
    strcpy(file,fil);
    line=lin;
    message[0] = '\0';
    code = cde;
    };
  
  int line;
  int code;
  char message[100];
  char file[100];
  };
  
#endif
