//****************************************************************************
//
// CCfile: Cpsout.cc
//
// Autor: A. Kipp
// erstellt: Thu May  9 11:48:35 1996 
// veraendert:
//
// Enthaelt: 
//****************************************************************************
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#include "Cpsout.h"
#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: Cpsout
// Autor: A. Kipp
// erstellt: Thu May  9 11:48:35 1996 
// veraendert:
//***************************************************************************
Cpsout::Cpsout(char* crea,char* dt)
{
  if( (pslibpath = getenv("PSLIBPATH")) == NULL )
    {
      pslibpath = strdup(".");
    }
  else
    {
      pslibpath = strdup(pslibpath);
    }

  if( (tmpf=fopen(PSTMP,"w"))== NULL )
    {
      failure(__FILE__,__LINE__,"Unable to open temporary File %s",
	      PSTMP);
    }
  out = NULL;
  date = dt==NULL ? strdup("now") : strdup(dt);
  creator = crea==NULL ? strdup("unknown") : strdup(crea);
}

int Cpsout::writeFile(char* filename,int nofpages)
{
  char buf[200];
  int readbytes;

  if( (out=fopen(filename,"w")) == NULL )
    {
      warning(__FILE__,__LINE__,"Error opening %s",filename);
    }

  if( (tmpf=freopen(PSTMP,"r",tmpf)) == NULL )
    {
      failure(__FILE__,__LINE__,"Cannot read from %s",PSTMP);
    }

  //write Header
  fprintf(out,"%%!PS-Adobe-2\n%%%%Creator: %s\n%%%%Date: %s\n",creator,date);
  if( nofpages > 0 )
    {
      fprintf(out,"%%%%Pages: %d\n",nofpages);
      fprintf(out,"%%%%PageOrder: Ascend\n");
    }

  while( (readbytes=fread(buf,1,200,tmpf)) > 0 )
    {
      fwrite(buf,1,readbytes,out);
    }
  fprintf(out,"%%%%EOF\n");
  if( (tmpf=freopen(PSTMP,"w",tmpf)) == NULL )
    {
      failure(__FILE__,__LINE__,"Cannot read from %s",PSTMP);
    }
}

int Cpsout::need(char* psfilename)
{
  FILE* needfp;
  char filename[200],buf[200];
  int readbytes;

  sprintf(filename,"%s/%s.ps",pslibpath,psfilename);

  if( (needfp=fopen(filename,"r")) == NULL )
    {
      warning(__FILE__,__LINE__,"Error reading needed file %s",filename);
      return -1;
    }

  fprintf(tmpf,"%%%% Start %s\n",psfilename);
  while( (readbytes=fread(buf,1,200,needfp)) > 0 )
    {
      fwrite(buf,1,readbytes,tmpf);
    }
  fprintf(tmpf,"%%%% End %s\n",psfilename);
  fclose(needfp);
  return 1;
}

Cpsout::~Cpsout()
{
  free(pslibpath);
  fclose(tmpf);
  unlink(PSTMP);
}
