//****************************************************************************
//
// CCfile: Cmlf.cc
//
// Autor: A. Kipp
// erstellt: Tue Sep 30 10:42:53 MET 1997
// veraendert:
//
// Enthaelt:
//***************************************************************************
#include <stdlib.h>
#include "Cmlf.h"
#include "CCexceptions.h"

//***************************************************************************
// Implementierung der Klasse: Cmlf
// Autor: A. Kipp
// erstellt: Tue Sep 30 10:42:53 MET 1997 
// veraendert:
//***************************************************************************
Cmlf::Cmlf()
{
  in = stdin;
}

void Cmlf::setIn(FILE* fp)
{
  in = fp;
}

int Cmlf::readFile()
{
  char line[200],label[100];
  int error=EOF;
  mlfsegment_rec* mlfsp;
  char* cp;
  enum states { pattern,transcription} pstate;
  int loffs,scoffs,aoffs;
  
  pstate=pattern;

  slist.clear();
  while( fgets(line,200,in) )
    {
      cp = strchr(line,'\n');
      if( cp )
	{
	  *cp = '\0';
	}
      if( !strncmp(line,"#!MLF!#",strlen("#!MLF!#")) )
	{
	  continue;
	}
      if( pstate == pattern )
	{
	  if( sscanf(line,"\"%[^\"]",filename) != 1)
	    {
	      return -1;
	    }
	  pstate = transcription;
	  continue;
	}
      if( line[0] == '.' )
	{
	  error=0;
	  break;
	}
      //ok, new segment
      mlfsp = new mlfsegment_rec;
      mlfsp->start = -1;
      mlfsp->end = -1;
      //parse line
      //try to read start and end
      loffs = 0;
      sscanf(line,"%d%n %d%n",&mlfsp->start,&loffs,&mlfsp->end,&loffs);
      //the label (required)
      if( sscanf(line + loffs,"%s%n",label,&scoffs) != 1 )
	{
	  error = 1;
	  delete mlfsp;
	  continue;
	}
      mlfsp->symbol = strdup(label);
      //try to read score
      aoffs = 0;
      sscanf(line + loffs + scoffs,"%lf%n",&mlfsp->score,&aoffs);
      //finaly addinfo
      cp = line + aoffs + loffs + scoffs;
      cp += strspn( cp ," \t");
      mlfsp->addinfo=strdup(cp);
      slist.addEl(&mlfsp);
    }
  return error ;
}

void Cmlf::clear()
  {
  mlfsegment_rec** srpp;
  
  for( srpp = slist.skipThru(init) ; srpp!=NULL ; srpp=slist.skipThru(next))
    {
      if( (*srpp)->addinfo != NULL )
	{
	  free( (*srpp)->addinfo );
	}
	    
      if( (*srpp)->symbol != NULL )
	{
	  free( (*srpp)->symbol );
	}
    delete *srpp;
    }
    
  slist.clear();
  }

Cmlf::~Cmlf()
{
  clear();
}
