# 2017-10-19 : generic version for the class 1 mult items list (input must be a single filtered
#              BPF class 1 tier that has word link lists (e.g. NOI); output is a single items list)

BEGIN { 
        first_idx = EMUID
        idx = EMUID
}
{ 
  # 2017-01-27 : accept white-space separated label sequences starting at column 3
  lab = $3
  i=4
  while($i != "")
  {
    lab = lab " " $i
    i ++
  }
  gsub(/\\/,"\\\\",lab)
  gsub(/"/,"\\\"",lab)
  tierlab[idx] = lab
  idx ++
}
END {
  for(i=first_idx;i<idx;i++) {
    printf("              {\n                    \"id\": %d,\n                    \"labels\": [\n                        {\n                            \"name\": \"%s\",\n                            \"value\": \"%s\"\n                        }\n                    ]\n              }",i,TIERNAME,tierlab[i])
    if(i<idx-1) printf(",")
    printf("\n") 
  }
}
