<?xml version="1.0" encoding="UTF-8"?>
<!-- change 03-03-2016: additional namespaces no longer necessary 
        xmlns:isoSpoken="http://iso-tei-spoken.org/ns/1.0"
        xmlns:standoff="http://standoff.proposal"
     change 08-07-2016: add parameter for language    
-->        
<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
        xmlns:exmaralda="http://www.exmaralda.org" 
        xmlns:xs="http://www.w3.org/2001/XMLSchema">
    
    <!-- new 08-07-2016 -->
    <!-- A parameter can be passed spcifying the language of the document -->
    <!-- xx is used as a default value if no such parameter is passed -->
    <xsl:param name="LANGUAGE">xx</xsl:param>
    <!-- new 25-06-2018 -->
    <!-- if this parameter is set to TRUE, XPointers will be used instead of IDREFs -->
    <xsl:param name="USE_XPOINTER">FALSE</xsl:param>
    
   
    <xsl:variable name="XPOINTER_HASH">
        <xsl:choose>
            <xsl:when test="$USE_XPOINTER='TRUE'">#</xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>            
    </xsl:variable>
    
    
    <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
    
    
    <!-- ****************************************************************** -->
    <!-- ************************ ROOT TEMPLATE    ************************ -->
    <!-- ****************************************************************** -->
    <xsl:template match="/">
        <TEI xmlns="http://www.tei-c.org/ns/1.0">
            <teiHeader>
                <!-- ***************************************************** -->
                <fileDesc>
                    <titleStmt>
                        <title/>
                    </titleStmt>
                    <publicationStmt>
                        <authority><!--Fill me in--></authority>
                        <availability>
                            <licence target="someurl"/>
                            <p><!--Fill me in--></p>
                        </availability>
                        <distributor><!--Fill me in--></distributor>
                        <address>
                           <addrLine><!--Fill me in--></addrLine>
                        </address>
                    </publicationStmt>
                    <!-- ***************************************************** -->
                    <sourceDesc>
                        <recordingStmt>
                            <recording type="video">
                                <!-- element from TEI P5, but not allowed there as a child of recording -->
                                <xsl:apply-templates select="//referenced-file"/>
                                <broadcast>
                                    <ab><xsl:comment>Fill me in</xsl:comment></ab>
                                </broadcast>
                                <!-- information about the equipment used for creating the recording -->
                                <!-- where recordings are made by the researcher, this would be -->
                                <!-- place to specify the recording equipment (e.g. Camcorder) -->
                                <equipment>
                                    <ab><xsl:comment>Fill me in</xsl:comment></ab>
                                    <ab><xsl:comment>Fill me in</xsl:comment></ab>
                                </equipment>                  
                            </recording>
                        </recordingStmt>                                        
                    </sourceDesc>
                    <!-- ... -->
                </fileDesc>
                <!-- ***************************************************** -->                
                <profileDesc>
                    <!-- ... -->
                    <particDesc>
                        <xsl:apply-templates select="//speaker"/>
                    </particDesc>        
                    <!-- ***************************************************** -->                
                    <settingDesc>
                        <place><xsl:comment>Fill me in</xsl:comment></place>
                        <setting>
                            <activity><xsl:comment>Fill me in</xsl:comment></activity>
                        </setting>
                    </settingDesc>                    
                </profileDesc>
                <encodingDesc>
                        <appInfo>
                                <!-- information about the application with which -->
                                <!-- the transcription was created -->
                                <application ident="EXMARaLDA" version="1.5.3">
                                        <label>EXMARaLDA Partitur-Editor</label>
                                        <desc>Transcription Tool providing a TEI Export</desc>
                                </application>
                        </appInfo>       
                        <!-- information about the transcription convention used -->
                        <!-- change 03-03-2016: namespace switch no longer necessary -->
                        <transcriptionDesc ident="HIAT" version="2004">
                                <desc><xsl:comment>Fill me in</xsl:comment></desc>
                                <label><xsl:comment>Fill me in</xsl:comment></label>
                        </transcriptionDesc>
                </encodingDesc>
                <revisionDesc>
                    <!-- ... -->                    
                    <xsl:element name="change">
                        <xsl:attribute name="when"><xsl:value-of select="current-dateTime()"/></xsl:attribute>
                        <xsl:text>Created by XSL transformation from an EXMARaLDA basic transcription</xsl:text>
                    </xsl:element>
                </revisionDesc>                
            </teiHeader>
            <text>
                <!-- new 08-07-2016 -->
                <!-- encode the language here -->
                <xsl:attribute name="xml:lang" select="$LANGUAGE"/>                
                
                <xsl:call-template name="MAKE_TIMELINE"/>
                <body>
                    <xsl:for-each select="//tli">
                        <xsl:for-each select="//tier[@type='t' and @speaker]/event[@start=current()/@id]">
                            <xsl:if test="not(preceding-sibling::event) or exmaralda:timeline-position(@start)&gt;exmaralda:timeline-position(preceding-sibling::event[1]/@end)">
                                <xsl:apply-templates select="." mode="first-pass"/>
                            </xsl:if>                            
                        </xsl:for-each>
                        <xsl:apply-templates select="//tier[@type='d']/event[@start=current()/@id]"/>
                    </xsl:for-each>                                    
                </body>
            </text>
        </TEI>            
    </xsl:template>
    
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <!-- **********           MEDIA          ************* -->
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <xsl:template match="referenced-file">
        <media  xmlns="http://www.tei-c.org/ns/1.0">
            <xsl:attribute name="mimeType"><xsl:value-of select="exmaralda:determine-recording-type(@url)"/>/xxx</xsl:attribute>
            <xsl:attribute name="url"><xsl:value-of select="@url"/></xsl:attribute>
        </media>        
    </xsl:template>
        
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <!-- **********         TIMELINE         ************* -->
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <xsl:template name="MAKE_TIMELINE">
        <timeline unit="s" xmlns="http://www.tei-c.org/ns/1.0">
            <!-- <xsl:attribute name="origin">
                <xsl:choose>
                    <xsl:when test="//tli[1]/@time=0.0"><xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="//tli[1]/@id"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="$XPOINTER_HASH"/>T_START</xsl:otherwise>
                </xsl:choose>                
            </xsl:attribute> -->
            <xsl:if test="//tli[1]/@time&gt;0.0">
                <when xml:id="T_START" xmlns="http://www.tei-c.org/ns/1.0" interval="0.0" since="T_START"/>                        
            </xsl:if>
            <xsl:apply-templates select="//tli"/>
        </timeline>        
    </xsl:template>
    
    <!-- CHANGE FOR ISO: use decimal seconds notation, use intervals and since instead of absoulute -->
    <xsl:template match="tli[position()&gt;1]">
        <xsl:element name="when" xmlns="http://www.tei-c.org/ns/1.0">
            <xsl:attribute name="xml:id">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:if test="@time">
                <xsl:attribute name="interval">
                    <xsl:value-of select="@time"/>
                </xsl:attribute>
                <xsl:attribute name="since">
                    <xsl:choose>
                        <xsl:when test="//tli[1]/@time=0.0"><xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="//tli[1]/@id"/></xsl:when>
                        <xsl:otherwise><xsl:value-of select="$XPOINTER_HASH"/>T_START</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:if>
        </xsl:element>                
    </xsl:template>
    
    <!-- CHANGE FOR ISO: special treatment for first -->
    <xsl:template match="tli[position()=1]">
        <xsl:choose>
            <xsl:when test="@time=0" >
                <when absolute="00:00:00.0" xmlns="http://www.tei-c.org/ns/1.0">
                    <xsl:attribute name="xml:id" select="@id"/>
                </when>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="when" xmlns="http://www.tei-c.org/ns/1.0">
                    <xsl:attribute name="xml:id">
                        <xsl:value-of select="@id"/>
                    </xsl:attribute>
                    <xsl:if test="@time">
                        <xsl:attribute name="interval">
                            <xsl:value-of select="@time"/>
                        </xsl:attribute>
                        <xsl:attribute name="since"><xsl:value-of select="$XPOINTER_HASH"/>T_START</xsl:attribute>
                    </xsl:if>
                </xsl:element>                                
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <!-- **********           SPEAKERS       ************* -->
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    
    <xsl:template match="speaker">
        <xsl:element name="person" xmlns="http://www.tei-c.org/ns/1.0">
            <xsl:attribute name="xml:id">
                <xsl:value-of select="@id"/>
            </xsl:attribute>
            <xsl:attribute name="n"><xsl:value-of select="abbreviation"/></xsl:attribute>
            <xsl:attribute name="sex">
                <xsl:choose>
                    <xsl:when test="sex/@value='m'">1</xsl:when>
                    <xsl:when test="sex/@value='f'">2</xsl:when>
                    <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>                
            </xsl:attribute>
            <xsl:element name="persName">
                <xsl:element name="forename">?</xsl:element>
                <xsl:element name="abbr"><xsl:value-of select="abbreviation"/></xsl:element>                                
            </xsl:element>
        </xsl:element>        
    </xsl:template>
    
    
    
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <!-- *******         TRANSCRIPTION       ************* -->
    <!-- ************************************************* -->
    <!-- ************************************************* -->

    <!-- events from primary transcription tiers with speakers with no immediately preceding event -->
    <!-- CHANGE FOR ISO: use annotationBlock instead of div -->
    <xsl:template match="event[../@speaker and ../@type='t']" mode="first-pass">
        <xsl:variable name="DIV_START"><xsl:value-of select="@start"/></xsl:variable>
        <xsl:variable name="DIV_END"><xsl:value-of select="exmaralda:last-endpoint-of-segment-chain(.)"/></xsl:variable>
        <!-- CHANGE FOR ISO: who, start and end attributes on annotationBlock instead of on u and as anchors -->
        <!-- change 03-03-2016: element renamed, namespace switch no longer necessary -->        
        <xsl:element name="annotationBlock" xmlns="http://www.tei-c.org/ns/1.0">            
            <xsl:attribute name="xml:id"><xsl:text>ab_</xsl:text><xsl:value-of select="generate-id()"/></xsl:attribute>
            <xsl:attribute name="who">
                <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="parent::tier/@speaker"/>
            </xsl:attribute>
            <xsl:attribute name="start">
                <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@start"/>                
            </xsl:attribute>
            <xsl:attribute name="end">
                <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="$DIV_END"/>                
            </xsl:attribute>
            <!-- change 03-03-2016: namespace switch no longer necessary -->        
            <xsl:element name="u">
                <xsl:attribute name="xml:id"><xsl:text>u_</xsl:text><xsl:value-of select="generate-id()"/></xsl:attribute>
                <xsl:value-of select="text()"/>
                <xsl:if test="following-sibling::event and exmaralda:timeline-position(@end)&gt;=exmaralda:timeline-position(following-sibling::event[1]/@start)">
                    <!-- ADDED 15-11-2016 -->
                    <xsl:element name="anchor" xmlns="http://www.tei-c.org/ns/1.0">
                        <xsl:attribute name="synch">
                            <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@end"/>
                        </xsl:attribute>
                    </xsl:element>
                    <xsl:apply-templates select="following-sibling::event[1]" mode="second-pass"/>
                </xsl:if>
            </xsl:element> <!-- end u -->
            
            <!-- take care of annotations belonging to this u -->            
            <xsl:for-each select="//tier[@speaker=current()/../@speaker and @type='a']">
                <xsl:call-template name="find-annotations">
                    <xsl:with-param name="START"><xsl:value-of select="$DIV_START"/></xsl:with-param>
                    <xsl:with-param name="END"><xsl:value-of select="$DIV_END"/></xsl:with-param>
                    <xsl:with-param name="TIER_ID"><xsl:value-of select="@id"/></xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:element> <!-- end div -->
    </xsl:template>
    
    <!-- events from primary transcription tiers with speakers with an immediately preceding event -->
    <xsl:template match="event" mode="second-pass">
            <xsl:value-of select="text()"/>
            <xsl:if test="following-sibling::event and exmaralda:timeline-position(@end)&gt;=exmaralda:timeline-position(following-sibling::event[1]/@start)">
                <xsl:element name="anchor" xmlns="http://www.tei-c.org/ns/1.0">
                    <xsl:attribute name="synch">
                        <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@end"/>
                    </xsl:attribute>
                </xsl:element>
                <xsl:apply-templates select="following-sibling::event[1]" mode="second-pass"/>
            </xsl:if>        
    </xsl:template>
    
    <!-- finds all annotations in the tier with the given TIER_ID which start at or after the given START point and which end at or before the given END --> 
    <xsl:template name="find-annotations">
        <xsl:param name="START"/>
        <xsl:param name="END"/>
        <xsl:param name="TIER_ID"/>
        
        <xsl:variable name="SPAN_GRP" >
            <xsl:element name="spanGrp">
                <xsl:for-each select="//tier[@id=$TIER_ID]/event">
                    <xsl:if test="exmaralda:timeline-position(@start)&gt;=exmaralda:timeline-position($START) and exmaralda:timeline-position(@end)&lt;=exmaralda:timeline-position($END)">
                        <xsl:element name="span">
                            <xsl:attribute name="from"><xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@start"/></xsl:attribute>
                            <xsl:attribute name="to"><xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@end"/></xsl:attribute>
                            <xsl:value-of select="text()"/>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:element>
        </xsl:variable>
        
        <xsl:if test="count($SPAN_GRP/descendant::span)&gt;0">
            <xsl:element name="spanGrp" xmlns="http://www.tei-c.org/ns/1.0">
                <xsl:attribute name="type"><xsl:value-of select="//tier[@id=$TIER_ID]/@category"/></xsl:attribute>
                <xsl:for-each select="$SPAN_GRP/descendant::span">
                    <xsl:element name="span" xmlns="http://www.tei-c.org/ns/1.0">
                        <xsl:attribute name="from"><xsl:value-of select="@from"/></xsl:attribute>
                        <xsl:attribute name="to"><xsl:value-of select="@to"/></xsl:attribute>
                        <xsl:value-of select="text()"></xsl:value-of>
                    </xsl:element>
                </xsl:for-each>
                <!-- <xsl:copy-of select="$SPAN_GRP/descendant::span"  xmlns="http://www.tei-c.org/ns/1.0"/> -->
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="event[../@type='d']">
        <xsl:message>HERE I GO!</xsl:message>
        <xsl:element name="incident" xmlns="http://www.tei-c.org/ns/1.0">
            <xsl:if test="../@speaker">
                <xsl:attribute name="who">
                    <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="../@speaker"/>
                </xsl:attribute>                
            </xsl:if>
            <xsl:attribute name="type">
                <xsl:value-of select="../@category"/>
            </xsl:attribute>
            <xsl:attribute name="start">
                <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@start"/>
            </xsl:attribute>
            <xsl:attribute name="end">
                <xsl:value-of select="$XPOINTER_HASH"/><xsl:value-of select="@end"/>
            </xsl:attribute>
            <xsl:element name="desc">
                <xsl:value-of select="text()"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    
    <!-- ************************************************* -->
    <!-- ************************************************* -->
    <!-- *******  VARIABLES AND FUNCTIONS    ************* -->
    <!-- ************************************************* -->
    <!-- ************************************************* -->

    <!-- memorizes position of timeline items for quicker reference -->
    <xsl:variable name="timeline-positions">
        <positions>
            <xsl:for-each select="//tli">
                <item>
                    <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
                    <xsl:attribute name="position"><xsl:value-of select="count(preceding-sibling::tli)"/></xsl:attribute>
                </item>
            </xsl:for-each>
        </positions>
    </xsl:variable>
    
    <!-- returns the position number of the timeline item with the given id -->
    <xsl:function name="exmaralda:timeline-position" as="xs:integer">
        <xsl:param name="timeline-id"/>
        <xsl:sequence select="$timeline-positions/descendant::item[@id=$timeline-id]/@position"/>
        <!-- <xsl:value-of select="$timeline-positions/descendant::item[@id=$timeline-id]/@position"/> -->
    </xsl:function>
    
    
    <!-- 
        FROM : https://stackoverflow.com/questions/70434184/too-many-nested-function-calls-in-xslt-tail-recursive
        The reason your function isn't tail-recursive is that a tail-recursive function must return the result of 
        the recursive call as is, without further processing. Your call requests further processing: 
        the xsl:value-of instruction asks for the result to be converted to a text node.

        Saxon can sometimes work out that you didn't really want this conversion, 
        but it can only do that if you declare the type of the function result.

        So you should make two improvements to your code, both of which are standard good coding practice: 
        (a) use xsl:sequence rather than xsl:value-of to return function results, and 
        (b) use an as attribute on xsl:function and xsl:param to declare the types of the function parameters and result.        
    -->
    
    
    <!-- returns latest event that is connected to the given event through an uninterrupted chain of other events -->
    <xsl:function name="exmaralda:last-endpoint-of-segment-chain" as="xs:string">
        <xsl:param name="event" as="node()"/>
        <xsl:choose>
            <xsl:when test="not($event/following-sibling::event) or exmaralda:timeline-position($event/following-sibling::event[1]/@start)&gt;exmaralda:timeline-position($event/@end)">
                <xsl:value-of select="$event/@end"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- <xsl:value-of select="exmaralda:last-endpoint-of-segment-chain($event/following-sibling::event[1])"/> -->
                <xsl:sequence select="exmaralda:last-endpoint-of-segment-chain($event/following-sibling::event[1])"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:function>
    
    <xsl:function name="exmaralda:determine-recording-type">
        <xsl:param name="path"/>
        <xsl:choose>
            <xsl:when test="ends-with(lower-case($path), '.wav')">audio</xsl:when>
            <xsl:when test="ends-with(lower-case($path), '.mp3')">audio</xsl:when>
            <xsl:when test="ends-with(lower-case($path), '.aif')">audio</xsl:when>
            <xsl:when test="ends-with(lower-case($path), '.snd')">audio</xsl:when>
            <xsl:otherwise>video</xsl:otherwise>
        </xsl:choose>        
    </xsl:function>
    
    <xsl:function name="exmaralda:seconds-to-timestring">
        <xsl:param name="seconds"/>
        <xsl:variable name="totalseconds">
            <xsl:value-of select="0 + $seconds"/>
        </xsl:variable>
        <xsl:variable name="hours">
            <xsl:value-of select="0 + floor($totalseconds div 3600)"/>
        </xsl:variable>
        <xsl:variable name="minutes">
            <xsl:value-of select="0 + floor(($totalseconds - 3600*$hours) div 60)"/>
        </xsl:variable>
        <xsl:variable name="seconds">
            <xsl:value-of select="0 + ($totalseconds - 3600*$hours - 60*$minutes)"/>
        </xsl:variable>
        <xsl:if test="$hours+0 &lt; 10 and $hours &gt;0">
            <xsl:text>0</xsl:text>
            <xsl:value-of select="$hours"/>
        </xsl:if>
        <xsl:if test="$hours + 0 = 0">
            <xsl:text>00</xsl:text>                            
        </xsl:if>
        <xsl:text>:</xsl:text>
        <xsl:if test="$minutes+0 &lt; 10">
            <xsl:text>0</xsl:text>
        </xsl:if>
        <xsl:value-of select="$minutes"/>
        <xsl:text>:</xsl:text>
        <xsl:if test="$seconds+0 &lt; 10">
            <xsl:text>0</xsl:text>
        </xsl:if>
        <xsl:value-of select="$seconds"/>            
    </xsl:function>
    
    
</xsl:stylesheet>

