//****************************************************************************
//
// CCfile: perplex_main.cc
//
// Autor: A. Kipp
// erstellt: Wed Nov 29 09:31:14 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "CCexceptions.h"
#include "Cdocsys.h"
#include "iotoolbox.h"
#include "Cperplex.h"
#include "verbmobil.h"
#include "Cmlf.h"

static char inventar[] = "/home/kip/projekte/vorschlagstrans/inventar.txt";
char segoutfile[] = "seg.out";
char *ignoresymbols[] = {"<p:>","<nib>",NULL};
char nulls[] = "!NULL,#,&";
char jokers[] = "_ins_,_rep_";

main(int argc,char** argv)
{
  char* appname,*hypin=NULL,*segin=NULL,*ch,*cp,*inventfile = inventar,
    dummy,hspkr[50],sspkr[50],line[200];
  char* segout = segoutfile;
  int hnum,snum;
  long pos;
  FILE* fp,*fphin,*fpsin=stdin,*fpsout;
  Chgraph *hgraph;
  Cmlf* mlf;
  Cperplex* perplex;
  Cdocsys doc;
  int anzseg;
  vmfinfo vihgr,viseg;
  int verbose=1;
  double pp;
  
  mlfsegment_rec** sptrptr;
   
  icsiargtab_t args[] =
  {
    {"hif","Hypthesen-Inputdir",ARG_STR,&hypin},
    {"sif","Segmentations-INputfile",ARG_STR,&segin},
    {"iv","inventar-file",ARG_STR,&inventfile},
    {"v","verbose",ARG_BOOL,&verbose},
    {"sof","segmentation-out",ARG_STR,&segout},
    {"nulls","nichtemittierende Knoten",ARG_STR,&nulls},
    {"jokers","Joker Knoten",ARG_STR,&jokers},
    {0,0,ARG_NOMOREARGS}
  }; 
   
  try
    {
      // Start of code
      icsiargs(args,&argc,(const char ***)&argv,&appname);
      hgraph = new Chgraph;
      mlf = new Cmlf;
      perplex = new Cperplex;
      perplex->verbose = verbose;
      if( hgraph->readInventar(inventfile) < 0 )
	{
	  //failure(__FILE__,__LINE__,"Error reading Inventar from %s",inventfile);
	}
       perplex->anzkl = hgraph->anzinv;

       for( cp=strtok(nulls,",") ; cp!=NULL ; cp=strtok(NULL,"," ) )
	 {
	   perplex->nulls.addEl(&cp);
	 }
       for( cp=strtok(jokers,",") ; cp!=NULL ; cp=strtok(NULL,"," ) )
	 {
	   perplex->jokers.addEl(&cp);
	 }
		
   
    
      if( segin == NULL )
	{
	  mlf->setIn(stdin);
	}
      else
	{
	  fpsin = fopen(segin,"r");
	  if( fpsin == NULL )
	    {
	      //failure(__FILE__,__LINE__,"couldn't open %s\n",segin);
	    }
	}
      mlf->setIn(fpsin);
     

      int err;
      while( (err=mlf->readFile()) != EOF )
	{
	  if( err != 0 )
	    {
	      fprintf(stderr,"Warning: couldn't read mlf\n");
	      continue;
	    }
   
	  
	  char path[200],body[100],ext[50];
	  char fn[200];
	  FILE* fp;
	  
	  lobotomo(mlf->getFilename(),path,body,ext);
	  sprintf(fn,"%s/%s.slf",hypin ? hypin : path,body);
	  
	  if( (fp=fopen(fn,"r")) == NULL )
	    {
	      //failure(__FILE__,__LINE__,"Error opening %s\n",fn);
	    }
	  hgraph->filename = strdup(fn);

	  hgraph->setIn(fp);
	  hgraph->setOut(stdout);
    

      if( hgraph->readHGraph() < 0 )
	{
	  //failure(__FILE__,__LINE__,"Error reading graph");
	}
	  
      if( verbose )
	{ 
	  printf("checking %s\n",hgraph->filename);
	}	  
      
      anzseg = mlf->slist.compact(&sptrptr);
      pp = perplex->find(hgraph,sptrptr,anzseg);
      printf("%s %lf %d\n",body,pp,anzseg);
      mlf->clear();
      hgraph->clear();
	  delete [] sptrptr;
	}
      // End of code 
    }
  catch(Ausnahme& a)
    {
      switch( a.code )
	{
	default:
	  fprintf(stderr,"%s %d : %s\n",a.file,a.line,a.message);
	  exit(1);
	}
    }
  catch(...)
    {
      exit(2);
    }
}
