//***************************************************************************
//
// Headerfile: Cpartitur_io.h
//
// Autor: A. Kipp
// erstellt: Thu Nov 16 12:34:09 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef PARTITUTIO
#define PARTITUTIO
#include "Cverklist.h"
#include "Cheader_io.h"
#include "Label.h"

struct PartiturRec
  {
  };
  
struct KanRec : PartiturRec
  {
  int wordnr;
  char* word;
  };

struct SamRec : PartiturRec,Label_ad
  {
  SamRec() {wrefs=NULL;nwrefs=0;};
  SamRec& operator=(const SamRec& sr)
    {
      symbol = sr.symbol==NULL ? (char*)NULL : strdup(sr.symbol);
      start = sr.start;
      score = sr.score;
      duration = sr.duration;
      nwrefs = sr.nwrefs;
      if( sr.nwrefs > 0 )
        {
          wrefs=new int[sr.nwrefs];
          memcpy(wrefs,sr.wrefs,sizeof(int)*sr.nwrefs);
        }
      return *this;
    };

  ~SamRec()
    {
      if( nwrefs>0 )
        {
          delete [] wrefs;
        }
    };

  int* wrefs;
  int nwrefs;
  };
  
struct TrlRec : PartiturRec
  {
  TrlRec() { line=NULL;};
  char* line;
  };
  
struct WrdRec : PartiturRec
  {
  WrdRec() { start=0;duration=0;word=NULL;wref=-1;}
  int start;
  int duration;
  char* word;
  int wref;
  };
    
struct RecHead
  {
  int id;
  Cverklist<PartiturRec*> recs;
  };
  
struct RecDesc
  {
  char* key;
  char* testmask;
  char* scanmask;
  char* printmask;
  frwfunc fptr;
  };  

//***************************************************************************
// Klassendeklaration: class Cpartitur_io
//
// Autor: A. Kipp
// erstellt: Thu Nov 16 12:34:09 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
class Cpartitur_io : public Cheader_io
  {
  public:
  Cpartitur_io();
  void recLabelheaderdesc();
  
  RecHead* recheads;
  int nrecs;
  
  static RecDesc descs[];

  char* headernameandversion;
  char* recordingsite;
  int bytespersample;
  char byteorder[4];
  int bitspersample;
  char speaker[10];
  int numchan;
  
  protected:
  };
#endif
