# inserts or expands an existing initial silence interval in the 
# mau segmentation by TRNOFFSET samples (based on FIXRATE!) 
# thus correcting the error caused by cutting out the 
# utterance from the original recording using the option USETRN.

BEGIN { first = 0 }

{
  if ( first == 0 )
  {
    # first segment is a silence interval
    if ( $4 == -1 )
    {
      dur = TRNOFFSET + $3
      printf("MAU:\t0\t%d\t-1\t<p:>\n",dur)
    }
    # there is no initial silence interval, so let's create one
    # but only if TRNOFFSET is larger than 0 (otherwise we'd insert a
    # silence with -1 duration!)
    else
    {
      if ( TRNOFFSET > 0 ) {
        dur = TRNOFFSET - 1
        printf("MAU:\t0\t%d\t-1\t<p:>\n",dur)
        printf("MAU:\t%d\t%d\t%d\t%s\n",TRNOFFSET,$3,$4,$5)
      }
      else {
        printf("MAU:\t%d\t%d\t%d\t%s\n",$2,$3,$4,$5)
      }
    }
    first = 1
  }
  else
    {
      # all subsequent segments are shifted by TRNOFFSET
      label = $5
      i = 6
      while($i != "") {
        label = label " " $i
        i++
      }
      printf("MAU:\t%d\t%d\t%d\t%s\n",$2+TRNOFFSET,$3,$4,label)
    }  
}  
