//****************************************************************************
//
// CCfile: Cheader_io.cc
//
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:34:11 1995 
// veraendert:
//
// Enthaelt: 
//****************************************************************************

#include "Cheader_io.h"
#include "CCexceptions.h"

#define MAXLINE 500

//***************************************************************************
// Implementierung der Klasse: Cheader_io
// Autor: A. Kipp
// erstellt: Wed Apr 26 10:34:11 1995 
// veraendert:
//***************************************************************************
int Cheader_io::readFile()
  {
  int i,nc,npos;
  char line[MAXLINE],*lp,*cp,dummy[50];
  struct vardef* vdp;
  int flag = EOF;
  err=0;
  erritem = -1;
  
  for( lines=0; fgets(line,MAXLINE,in) != NULL ; lines++ )
    {
    if( !strncmp(line,endmarker,strlen(endmarker)) )
      {
      flag = 1;
      break;
      }
      
    if( !strncmp(line,commentmarker,strlen(commentmarker)) )
      {
      continue;
      }
    for( vdp=vardeflist.skipThru(init) ; vdp != NULL ; 
        vdp=vardeflist.skipThru(next) )
      {
      switch( vdp->typ )
        {
        case vcvar:
          if( sscanf(line,vdp->mask,
                                     vdp->atyp.addr) )
          {
          vdp->hit++;
          }
          
          break;
        case vstring:
          if( !strncmp(line,vdp->mask,strlen(vdp->mask)) )
            {
            cp=strchr(line,'\n');
            if( cp != NULL )
              {
              *cp='\0';
              }
            lp=strdup(line + strlen(vdp->mask));
            *vdp->atyp.cpp = lp;
            vdp->hit++;
            }
          break;
        case vstringlist:
          if( sscanf(line,vdp->mask + 1,dummy) >=
              vdp->mask[0] - '0' )
            {
            cp=strchr(line,'\n');
            if( cp != NULL )
              {
              *cp='\0';
              }
            lp = strdup(line);
            vdp->atyp.vclist->addEl(&lp);
            vdp->hit++;
            }
          break; 
              
        case vlist:
          if( sscanf(line,vdp->mask + 1,dummy) >=
            vdp->mask[0] - '0' )
            {
            vdp->hit += (*vdp->atyp.frw)(readf,line,this,in);
            }
          break;
        }//--switch
      }//--for i
    }//--while fgets
    
  for( vdp=vardeflist.skipThru(init),i=0 ; vdp != NULL ; 
        vdp=vardeflist.skipThru(next),i++ )
    {
    if( vdp->rqd && !vdp->hit )
      {
      err++;
      erritem = i;
      }
    }
  return err > 0 ? READ_ERR : flag;
  }
  
void Cheader_io::writeFile()
  {
  int i;
  char** cpp,*cp,*convcp,*modcp,buffer[100];
  char* convchars = "duoxiefgsc[";
  char* modchars = "hl";
  struct vardef* vdp;
  
  for( vdp=vardeflist.skipThru(init) ; vdp != NULL ; 
        vdp=vardeflist.skipThru(next) )
    {
    switch( vdp->typ )
      {
      case vcvar:
        cp = strchr(vdp->mask,'%');
        if( cp == NULL )
          {
          failure(__FILE__,__LINE__,"Bad Format String for typ vcvar: %s",
          vdp->mask);
          }
        //Typ 'rausfinden
        convcp = strpbrk(cp,convchars);
        modcp = strpbrk(cp,modchars);
        if( convcp == NULL )
          {
          failure(__FILE__,__LINE__,"Bad Format String for typ vcvar: %s",
          vdp->mask);
          }
          
        switch( *convcp )
          {
          case 'd':
          case 'o':
          case 'x':
          case 'i':
            if( modcp == NULL || modcp > convcp )
              {
              fprintf(out,vdp->mask,*((int*)vdp->atyp.addr));
              }
            else if( *modcp == 'l' )
              {
              fprintf(out,vdp->mask,*((long*)vdp->atyp.addr));
              }
            else if( *modcp == 'h' )
              {
              fprintf(out,vdp->mask,*((short*)vdp->atyp.addr));
              }
            else
              {
              fprintf(out,vdp->mask,*((int*)vdp->atyp.addr));
              }
            break;
            
          case 'u':
            if( modcp == NULL || modcp > convcp )
              {
              fprintf(out,vdp->mask,*((unsigned int*)vdp->atyp.addr));
              }
            else if( *modcp == 'l' )
              {
              fprintf(out,vdp->mask,*((unsigned long*)vdp->atyp.addr));
              }
            else if( *modcp == 'h' )
              {
              fprintf(out,vdp->mask,*((unsigned short*)vdp->atyp.addr));
              }
            else
              {
              fprintf(out,vdp->mask,*((int*)vdp->atyp.addr));
              }
            break;
            
          case 'e':
          case 'f':
          case 'g':
            if( modcp == NULL || modcp > convcp )
              {
              fprintf(out,vdp->mask,*((float*)vdp->atyp.addr));
              }
            else if( *modcp == 'l' )
              {
              fprintf(out,vdp->mask,*((double*)vdp->atyp.addr));
              }
            else if( *modcp == 'h' )
              {
              fprintf(out,vdp->mask,*((float*)vdp->atyp.addr));
              }
            else
              {
              fprintf(out,vdp->mask,*((float*)vdp->atyp.addr));
              }
            break;
            
          case 'c':
            fprintf(out,vdp->mask,*((char*)vdp->atyp.addr));
            break;
            
          case 's':
          default:
            fprintf(out,vdp->mask,(char*)vdp->atyp.addr);
          }
       
        fprintf(out,"\n");
        break;
      case vstring:
        fprintf(out,"%s%s\n",vdp->mask,*vdp->atyp.cpp);
        break;
      case vstringlist:
        for( cpp = vdp->atyp.vclist->skipThru(init) ; cpp != NULL ; 
           cpp=vdp->atyp.vclist->skipThru(next) )
          {
          fprintf(out,"%s\n",*cpp);
          }
        break;
      case vlist:
        (*vdp->atyp.frw)(writef,NULL,this,out);
        break;
      }
    }
  fprintf(out,"%s\n",endmarker);
  }
      
void Cheader_io::specCvar(char* format,void* addr,int rqd)
  {
  struct vardef va;
  
  va.mask = strdup(format);
  va.typ=vcvar;
  va.atyp.addr = addr;
  va.rqd = rqd;
  vardeflist.addEl(&va);
  }
  
void Cheader_io::specString(char* format,char** cpp,int rqd)
  {
  struct vardef va;
  
  va.mask = strdup(format);
  va.typ=vstring;
  va.atyp.cpp = cpp;
  va.rqd = rqd;
  vardeflist.addEl(&va);
  }
  
void Cheader_io::specClist(char* format,Cverklist<char*>* vclist,int rqd)
  {
  struct vardef va;
  
  va.mask = strdup(format);
  va.typ=vstringlist;
  va.atyp.vclist = vclist;;
  va.rqd = rqd;
  vardeflist.addEl(&va);
  }
  
void Cheader_io::specList(char* format,frwfunc frw,void* addr,int rqd)
  {
  struct vardef va;
  
  va.mask = strdup(format);
  va.typ=vlist;
  va.atyp.frw = frw;
  
  va.rqd = rqd;
  vardeflist.addEl(&va);
  }
