//****************************************************************************
//
// CCfile: Cmatrix.cc
//
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//
// Enthaelt:
//****************************************************************************
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Cmatrix.h"



//***************************************************************************
// Implementierung der Klasse: Cvektor
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Cvektor::Cvektor(double* x,int dim) 
  {
  data = new double[dim];
  dimension=dim; 
  if( data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
  bcopy(x,data,dim*sizeof(double));
  mem=0;
  }

Cvektor::Cvektor(int dim) 
  { 
  data = new double[dim];dimension=dim; 
  if( data == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }
  mem=1;
  } 

void Cvektor::copyVek(Cvektor* ziel)
  {
  bcopy(data,ziel->data,dimension*sizeof(double));
  }

void Cvektor::clearVek()
  {
  bzero(data,dimension*sizeof(double));
  }

Cvektor::~Cvektor()
  {
  if( mem )
    {
    delete [] data;
    }
  }

//***************************************************************************
// Implementierung der Klasse: Cmatrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Cmatrix::Cmatrix(Cvektor* p_row, int nr)
  {
  int i;

  pp_row = new Cvektor*[nr];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=p_row[0].dim();
  num_of_rows=nr;

  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=p_row + i;
    }

  mem=0;
  }

Cmatrix::Cmatrix(double* data,int nr, int nc)
  {
  int i;

  pp_row = new Cvektor*[nr];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=nc;
  num_of_rows=nr;

  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=new Cvektor(data + i*nc, nc);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1;
  }

Cmatrix::Cmatrix(int nr, int nc)
  {
  int i;

  pp_row = new Cvektor*[nr];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=nc;
  num_of_rows=nr;

  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=new Cvektor(nc);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1;
  }
void Cmatrix::clearMat()
  {
  int i;

  for( i=0 ; i<num_of_rows ; i++ )
    {
    pp_row[i]->clearVek();
    }
  }

Cmatrix::~Cmatrix()
  {
  int i;

  if( mem )
    {
    for( i=0 ; i<num_of_rows ; i++ )
      {
      delete pp_row[i];
      }
    }

  delete [] pp_row;
  }


//***************************************************************************
// Implementierung der Klasse: Cquad_matrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

int Cquad_matrix::solveGlsy(Cvektor* inh)
  {
  int r,rr,c,i,pivrow;
  double pivel,colel,el,max;
  Cvektor* tmp,**pp_r;

  pp_r = new Cvektor*[num_of_rows];

  if( pp_r == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  // zeiger auf die zeilenvektoren
  for( i=0 ; i<num_of_rows ; i++ )
    {
    pp_r[i]=pp_row[i];
    }

  for( r=0 ; r<num_of_rows ; r++ )
    {
    // Pivotsuche
    max=0.0;
    for( rr=r ; rr < num_of_rows ; rr++ )
      {
      if( (el=fabs( pp_r[rr]->getVal(r) ) ) > max )
        {
        max=el;
        pivrow=rr;
        }
      }

    if( max == 0.0 )
      {
      return CMATRIX_DET0;
      }
    pivel=pp_r[pivrow]->getVal(r);

    // tauschen
    tmp = pp_r[r];
    pp_r[r] = pp_r[pivrow];
    pp_r[pivrow] = tmp;

    // inhomogenitaet
    el=inh->getVal(r);
    inh->setVal(r,inh->getVal(pivrow));
    inh->setVal(pivrow,el);

    for( rr=0 ; rr<num_of_rows ; rr++ )
      {
      if( rr == r )
        {
        continue;
        }

      // zeilentranf
      colel=pp_r[rr]->getVal(r);
      for( c=r ; c<num_of_cols ; c++)
        {
        pp_r[rr]->decVal(c,(colel/pivel)*pp_r[r]->getVal(c));
        }
      // inhomogenitaet
      inh->decVal(rr,(colel/pivel)*inh->getVal(r) );
      }

    } // for r

  for( c=0 ; c<num_of_cols ; c++)
    {
    colel=inh->getVal(c);
    inh->setVal(c,colel/pp_r[c]->getVal(c));
    }
  
  return CMATRIX_SOLVED;
  }
void Cmatrix::printMat()
  {
  int r,c;

  for( r=0 ; r<num_of_rows ; r++)
    {
    for( c=0 ; c<num_of_cols ; c++ )
      {
      printf("(%d,%d) = %lf\n",r,c,getVal(r,c));
      }
    }
  }

//***************************************************************************
// Implementierung der Klasse: Csym_matrix
// Autor: A. Kipp
// erstellt: 09.94 veraendert: 10.94
//***************************************************************************

Csym_matrix::Csym_matrix(int dim) : Cquad_matrix()
  {
  int i;

  pp_row = new Cvektor*[dim];
  if( pp_row == 0 )
    {
    fprintf(stderr,"Out of Mem %s %d\n",__FILE__,__LINE__);
    exit(1);
    }

  num_of_cols=dim;
  num_of_rows=dim;

  for( i=0 ; i<nr ; i++ )
    {
    pp_row[i]=new Cvektor(dim-i);
    if( pp_row[i] == 0 )
      {
      fprintf(stderr,"Out of Mem %s %d (at row %d)\n",__FILE__,__LINE__,i);
      exit(1);
      }
    }
  mem=1;
  }  

Csym_matrix::double getVal(int r, int c)
  }
  if( c >= r )
    {
    return pp_row[r]->getVal(r,c-r);
    }
  else
    {
    return pp_row[c]->getVal(c,r-c);
    }
  }   

Csym_matrix::setVal(int r, int c, double l)
  }
  if( c >= r )
    {
    pp_row[r]->setVal(r,c-r);
    }
  else
    {
    pp_row[c]->setVal(c,r-c);
    }
  }
 
Csym_matrix::incVal(int r, int c, double l)
  }
  if( c >= r )
    {
    pp_row[r]->incVal(r,c-r);
    }
  else
    {
    pp_row[c]->incVal(c,r-c);
    }
  }

Csym_matrix::decVal(int r, int c, double l)
  }
  if( c >= r )
    {
    pp_row[r]->decVal(r,c-r);
    }
  else
    {
    pp_row[c]->decVal(c,r-c);
    }
  }
