BEGIN { first_idx = EMUID 
        idx = EMUID
        first_segment = 1 
}
{ 
  # this script gets filtered BPF class 4 tiers!

  # if the length of the segment is zero, skip it to be consistent with the transformed class 4 level
  # where these are suppressed
  if($3==0) next

  # check for inserted silence segments (as in transformed class 4 level)
  # look for gap before first segment and if so, insert an extra link from bundle
  if(first_segment==1 && $2!=0) {
    ortidx[idx] = -1  # tier word link starts with 0! This is a link from 0 (bundle) in emu indices!
    idx ++
  }
  # look for gap to the previous segment and if so, insert an extra link from bundle
  if(first_segment==0 && $2>(prevtierbeg+prevtierdur+1)) {
    ortidx[idx] = -1  # tier word link starts with 0! This is a link from 0 in emu indices!
    idx ++
  }

  # store word indices in ortidx
  if($4=="-1") {
    # free-floating segment : link to bundle
    ortidx[idx] = -1  # tier word link starts with 0! This is a link from 0 in emu indices!
  }
  else {
    # consistency check: if there is no class 1 tier, we can't have word links other than '-1'
    if(CLASS1LEVEL=="") {
      printf("ERROR: mausbpf2emuR : input BPF has no class 1 tier but a class 4 tier that links to it - exiting\n") > "/dev/stderr"
      exit(1)
    }
    ortidx[idx] = $4
  }
  first_segment = 0
  idx ++
  prevtierbeg = $2
  prevtierdur = $3
}
END {
  # look for gap after last input segment to end of signal and if so, insert an extra link from bundle
  if(ENDSAMPLE>(prevtierbeg+prevtierdur+1)) {
    ortidx[idx] = -1  # tier word link starts with 0! This is a link from 0 in emu indices!
    idx ++
  }

  # make the print
  for(i=first_idx;i<idx;i++) {
    nc = split(ortidx[i],carr,/[,;]/)
    for(j=1;j<=nc;j++) {
      # BPF links start with 0, but class 1 level starts with 1!
      printf("        {\n            \"fromID\": %d,\n            \"toID\": %d\n        }",carr[j]+1,i)
      if( i<idx-1 || j<nc ) printf(",")
      printf("\n")
    }
  }
}
