# 2017-05-31 : mask double quotes and backslashes in label strings, and restore 
#              blanks in label strings, e.g. something like bEr\O u"pt is now 
#              translated into JSON conform "bEr\\O u\"pt"
# 2017-10-19 : generic version for the class 1 items list (input must be filtered
#              BPF class 1 tiers; output is a single items list with attributes)

BEGIN { 
	idxmax = -1
        idxmin = 9999999 
        tieridx = 0 # the index over processed class 1 tiers
        prevkey = "" 
}
/^[A-Z][A-Z][A-Z]:/ { 
  # 2017-01-27 : accept white-space separated ORT sequences starting at column 3
  key = $1
  gsub(/:/,"",key) 
  if(key != prevkey) tieridx ++
  lab = $3
  i=4
  while($i != "")
  {
    lab = lab " " $i
    i ++
  }
  idx = $2 + 1
  gsub(/\\/,"\\\\",lab)
  gsub(/"/,"\\\"",lab)
  tierlab[tieridx,idx] = lab
  tierkey[tieridx,idx] = key
  if(idx>idxmax) idxmax = idx
  if(idx<idxmin) idxmin = idx
  prevkey = key
}
END {
  for(idx=idxmin;idx<=idxmax;idx++) {
    printf("              {\n                    \"id\": %d,\n                    \"labels\": [\n",idx)
    for(tidx=1;tidx<=tieridx;tidx++) {
      printf("                        {\n                            \"name\": \"%s\",\n                            \"value\": \"%s\"\n                        }",tierkey[tidx,idx],tierlab[tidx,idx])
      if(tidx < tieridx) printf(",")
      printf("\n")
    }
    printf("                    ]\n              }")
    if(idx<idxmax) printf(",")
    printf("\n") 
  }
}
