# 2017-05-31 : mask double quotes and backslashes in label strings, and restore
#              blanks in label strings, e.g. something like bEr\O u"pt is now      
#              translated into JSON conform "bEr\\O u\"pt"
# 2017-10-19 : generic script for all class 4 BPF tiers: creates emu items list
#              without attributes string with emu id EMUID; input is the filtered
#              BPF class 4 tier.
# 2019-03-22 : BPF segments with begin = dur = 0 are ignored (can happen in SAP/PHO)
# 2019-10-08 : clones mausbpf2emuR_class4.awk to this file for class 2 support

BEGIN { first_idx = EMUID
        idx = EMUID }
{ 
  # ignore segments that have duration = 0 (can happen in IPA deleted segments)
  if($3 == 0) next

  key = $1
  gsub(/:/,"",key)
  # get everything from column 4 to end (could be white space in the MAS label!)
  lab = $4
  i=5
  while($i != "")
  {
    lab = lab " " $i
    i ++
  }
  # mask \ "
  gsub(/\\/,"\\\\",lab)
  gsub(/"/,"\\\"",lab)
  tierlab[idx] = lab
  tierbeg[idx] = $2
  tierdur[idx] = $3
  idx ++
}
END {
  for(i=first_idx;i<idx;i++) {
    printf("              {\n                    \"id\": %d,\n                    \"sampleStart\": %d,\n                    \"sampleDur\": %d,\n                    \"labels\": [\n                        {\n                            \"name\": \"%s\",\n                            \"value\": \"%s\"\n                        }\n                    ]\n              }",i,tierbeg[i],tierdur[i],key,tierlab[i])
    if(i<idx-1) { printf(",\n") }
    else { printf("\n") }
  }
}

