# manipulate the HTK *.mmf read from input so that in all HMM with more states
# than 5 (= more than 3 real states!) a transition from the 4th state to the
# end state is added to the <TRANSP> matrix. This effectively results in a set of HMM
# where every HMM has the same minimal duration of 3 states (= 30msec for a standard
# frame rate).  

BEGIN {
             TransP = 0.05    # the transProb to the end state
      }
! /<TRANSP>/ { print }

/<TRANSP>/ { 
             # get the dim of the matrix
             dim = $2
             print
             # if a HMM with less than 6 states, do nothing (less than 4 real states!)
             if(dim<6) next
             # otherwise, read and print the first three lines of the matrix (unchanged)
             getline
             print
             getline
             print
             getline
             print
             # in the 4th line (which describes the transitions originating from the 4th state
             # substract TransP in the 4th column (self jump) and add it to the last column
             getline
             $4= $4 - TransP
             $NF = $NF + TransP
             for(j=1;j<=NF;j++) {
               printf(" %.6e",$j)
             }
             printf("\n")
}

                          

