//***************************************************************************
//
// Headerfile: CCexceptions.h
//
// Autor: A. Kipp
// erstellt: Thu Jan 19 17:43:21 1995 
// veraendert:
//
// Enthaelt:
//***************************************************************************
#ifndef CCEXCEPTIONS
#define CCEXCEPTIONS

#include <stdio.h>
#include <string.h>


#define GEN_AUSN_STR "Unspecified exception"

// user exceptions
#define MESSAGE_FORMAT_SDS "File %s, line %d : %s"
#define MESSAGE_FORMAT_SDSS "File %s, line %d : %s %s"
#define MESSAGE_FORMAT_SDSSS "File %s, line %d : %s %s %s"
// prededined exceptions
#define MESSAGE_FORMAT_SDDS "File %s, line %d : Exception %d : %s"
#define MESSAGE_FORMAT_SDDSS "File %s, line %d : Exception %d : %s %s"
#define MESSAGE_FORMAT_SDDSSS "File %s, line %d : Exception %d : %s %s %s"

#define OUT_OF_MEM_AUSN 1
#define CONSTRUCTION_FAILED 2
#define USER_AUSN 0


//***************************************************************************
// Klassendeklaration: class CCexceptions
//
// Autor: A. Kipp
// erstellt: Thu Jan 19 17:43:21 1995 
// veraendert:
// Kurzbeschreibung:
//***************************************************************************
struct Ausnahme
  {
  public:
  Ausnahme()
    {
    strcpy(message,GEN_AUSN_STR);
    code = USER_AUSN;
    };
    
  // user-Ausnahmen
  Ausnahme(char* file,int line)
    {
    sprintf(message,MESSAGE_FORMAT_SDS,GEN_AUSN_STR);
    code = USER_AUSN;
    };

  Ausnahme(char* file,int line,char* msge)
    {
    sprintf(message,MESSAGE_FORMAT_SDS,file,line,msge);
    code = USER_AUSN;
    };
    
  Ausnahme(char* file,int line,char* msge,char* arg)
    {
    sprintf(message,MESSAGE_FORMAT_SDSS,file,line,msge,arg);
    code = USER_AUSN;
    };
    
  Ausnahme(char* file,int line,char* msge,char* arg1,char* arg2)
    {
    sprintf(message,MESSAGE_FORMAT_SDSSS,file,line,msge,arg1,arg2);
    code = USER_AUSN;
    };
    
  // predefined Eceptions
  Ausnahme(int cod,char* file,int line)
    {
    sprintf(message,MESSAGE_FORMAT_SDDS,file,line,cod,GEN_AUSN_STR);
    code = cod;
    };
    
  Ausnahme(int cod,char* file,int line,char* msge)
    {
    sprintf(message,MESSAGE_FORMAT_SDDS,file,line,cod,msge);
    code = cod;
    };
    
  Ausnahme(int cod,char* file,int line,char* msge,char* arg)
    {
    sprintf(message,MESSAGE_FORMAT_SDDSS,file,line,cod,msge,arg);
    code = cod;
    };
    
  Ausnahme(int cod,char* file,int line,char* msge,char* arg1,char* arg2)
    {
    sprintf(message,MESSAGE_FORMAT_SDDSSS,file,line,cod,msge,arg1,arg2);
    code = cod;
    };
 
  int getCode() {return code;};
  char* getMessage() { return message;};
  
  protected:
  int code;
  char message[100];
  };
  
#endif
