# helper that determines the order of appearance of speaker labels in SPD
# and then replace the original labels by 'S1', 'S2', ..., or,
# if the option speakMatch is a list of names, replace the original labels
# by these names (if there are less names in the comma separated list, the 
# rest of labels are kept 'S#'), or
# if the option speakMatch contains value pairs 'S#:name' instead of simple
# names, only the listed 'S#' are replaced (other value strings before the 
# colon than 'S#' are ignored).
# Names must not contain white space or the colon ':'.

BEGIN {
        # get SPD segments and determine the order of speaker label appearance
        # as index in the array spkName (value is the normalized speaker name)
        i = 1
        sName = "S" i
        while( getline < SPD > 0 )
        {
          if( $1 != "SPD:" || $4 == "<p:>" || $4 == "<unknown>" ) continue
          if(spkName[$4] == "" ) {
            spkName[$4] = sName
            nameSpk[sName] = $4    # we need that for later re-indexing
            i ++
            sName = "S" i
          }
        }
        # add special label names that are not changed
        spkName["<p:>"] = "<p:>"
        spkName["<unknown>"] = "<unknown>"
#        for(i in spkName) { printf("spkName[%s] = %s\n",i,spkName[i]) }
        # process option 'speakMatch'
        if( speakMatch != "" ) {
          # split by comma
          sManz = split(speakMatch,sMarr,/,/)
          for(i in sMarr) {
            if( match(sMarr[i],/:/) == 0 ) {
              # if element contains no colon, replace name value in spkName at 
              # the same numbered index 'S#'
              sName = "S" i
              if( nameSpk[sName] != "" ) spkName[nameSpk[sName]] = sMarr[i]
            } else {
              # its a value:name pair, e.g. 'S1:Ralph'; split this and do the replacement in spkName
              # value names that are not used in SPD are ignored
              split(sMarr[i],pairArr,/:/)
              sName = pairArr[1]
              if( nameSpk[sName] != "" ) spkName[nameSpk[sName]] = pairArr[2]
            }
          }
        }
}

/^SPD:/ {
          # go over the SPD tier and replace label names
          printf("SPD:\t%s\t%s\t%s\n",$2,$3,spkName[$4])
}
!/^SPD:/ { print }


