#include <stdio.h>
#include "getopt.h"
#include <string.h>

#include "CsignalFile.h"

#define WINDOWSIZE 10000
#define MAXSHIFT 1000

struct marseg
{
  int beg;
  int end;
  char label[50];
};

CsignalFile* newSignalFile(char* filename);
int readSignalFile(CsignalFile* sfp,short* buf,int center,int nsamp);

main(int argc,char** argv)
{
  char* refin = NULL;
  char* syncin = NULL;
  char* marfile = NULL;
  int syncta=0,synctb=0;
  char c;
  int i,indx,t,k,shift;
  int turnanz=0;
  int verb = 0;
  double akfval[MAXSHIFT];
  short bufferref[WINDOWSIZE];
  short buffersync[WINDOWSIZE - MAXSHIFT];
  double bufftmp[WINDOWSIZE*2];
  marseg* turnmar = NULL;
  int rfak=1,rquot=1;

  CsignalFile* refsig;
  CsignalFile* syncsig;


  struct option options[] = {
    {  "refsig",required_argument,NULL,'a'},
    {  "mar",required_argument,NULL,'m'},
    {  "str",required_argument,NULL,'s'},
    {  "verbose",no_argument,&verb,1},
    { NULL,0,NULL,0}
  };


  while( (c=getopt_long(argc,argv,"a:m:s:t:",options,&indx)) != -1 )
    {
      switch( c )
	{
	case 'a':
	  refin = strdup(optarg);
	  break;
	case 'm':
	  marfile = strdup(optarg);
	  break;
	case 's':
	  if( sscanf(optarg,"%d",&syncta ) == 0 )
	    {
	      fprintf(stderr,"Synctime mus be an integter\n");
	      exit(1);
	    }
	  break;
	case '?':
	  exit(1);
	}
    }

  if( syncta == 0  )
    {
      fprintf(stderr,"set both sync-times!\n");
      exit(1);
    }
  if( refin == NULL )
    {
      fprintf(stderr,"missing ref-inputfile\n");
      exit(1);
    }

  char body[20],ext[5];
  if( sscanf(refin,"%[^.].%s",&body,&ext) != 2 )
    {
      fprintf(stderr,"need filename body + extension\n");
      exit(1);
    }

  FILE* fpmar;
  char line[200];

  if( marfile != NULL )
    {
      if( (fpmar = fopen( marfile,"r")) == NULL )
	{
	  fprintf(stderr,"missing mar-inputfile %s\n",marfile);
	  exit(1);
	}
      //faktor, um auf die samplepunkete eines 16kHz-files zu kommen
      rfak = !strcmp(ext,"al") ? 2 : 1;
      
      marseg ms;
      while( fgets(line,150,fpmar) )
	{
	  if( sscanf(line,"%d %d %s",&ms.beg,&ms.end,ms.label) == 3 )
	    {
	      turnanz++;
	    }
	}
      
      if( turnanz == 0 )
	{
	  fprintf(stderr,"Empty marfile %s\n",marfile);
	  exit(1);
	}
      turnmar = new marseg[turnanz];
      rewind(fpmar);

      for( i=0 ; fgets(line,150,fpmar) ; )
	{
	  if( sscanf(line,"%d %d %s",&ms.beg,&ms.end,ms.label) == 3 )
	    {
	      sscanf(line,"%d %d %s",&turnmar[i].beg,&turnmar[i].end,
		     turnmar[i].label);
	      i++;
	    }
	}
      
      fclose(fpmar);
    }
  

  if( (refsig = newSignalFile(refin)) == NULL )
    {
      exit(1);
    }
      
  if( readSignalFile(refsig,bufferref,syncta,WINDOWSIZE ) !=
      WINDOWSIZE )
    {
      fprintf(stderr,"Error getting ref-data\n");
      exit(1);
    }

  for( k=optind ; k+1<argc ; k+=2 )
    {
      if( (syncsig = newSignalFile(argv[k])) == NULL )
	{
	  exit(1);
	}
      
      char* fnp = strrchr(argv[k],'/');
      fnp = fnp == NULL ?  argv[k] : fnp + 1;
      if( sscanf(fnp,"%[^.].%s",&body,&ext) != 2 )
	{
	  fprintf(stderr,"need filename body + extension: %s\n",argv[k]);
	  exit(1);
	}
      //teiler, um 16kHz-file-samples zu transformieren
      rquot = !strcmp(ext,"al") ? 2 : 1;

      if( sscanf(argv[k+1],"%d",&synctb) != 1 )
	{
	  fprintf(stderr,"specify sync-time!\n");
	  exit(1);
	}

      if( readSignalFile(syncsig,buffersync,synctb,WINDOWSIZE-MAXSHIFT ) !=
	  WINDOWSIZE - MAXSHIFT)
	{
	  fprintf(stderr,"Error getting ref-data\n");
	  exit(1);
	}
      else
	{
	  FILE* fptmp = fopen("tmp.16","w");
	  fwrite(buffersync,2,WINDOWSIZE-MAXSHIFT,fptmp );
	}
  
      for( t=0 ; t<MAXSHIFT ; t++)
	{
	  akfval[t] = 0;
	  for( i=0 ; i<WINDOWSIZE-MAXSHIFT; i++ )
	    {
	      akfval[t] +=  bufferref[t+i] * buffersync[i];
	    }
	}


      int mat=0,mit=0;
      double max = 0.0;
      double min= 0.0;
      for( t=0 ; t<MAXSHIFT; t++ )
	{
	  if( akfval[t] > max )
	    {
	      max = akfval[t];
	      mat = t;
	    }
	  if( akfval[t] < min )
	    {
	      min = akfval[t];
	      mit = t;
	    }
	}
      
      printf("%s %lf\n",argv[k],(-1)*min > max ? 
      (syncta - synctb) + ((double)mit - MAXSHIFT/2)/8 :
      (syncta - synctb) + ((double)mat - MAXSHIFT/2)/8);

      shift = (syncta - synctb)*8  + ( (-1)*min > max ? mit - MAXSHIFT/2 :
	mat - MAXSHIFT/2 );

      if( marfile != NULL )
	{
	  //write out the mar-file
	  body[strlen(body)-2] = '\0';
	  sprintf(line,"%s.mar",body);
	  FILE* fpmo = fopen(line,"w");
	  if( fpmo == NULL )
	    {
	      fprintf(stderr,"Error opening out-marfile %s\n",line );
	      exit(1);
	    }
	  
	  for( i=0 ; i<turnanz ; i++ )
	    {
	      fprintf(fpmo,"%d %d %s\n",turnmar[i].beg*rfak/rquot - 2*shift/rquot,
		      turnmar[i].end*rfak/rquot - 2*shift/rquot,
		      turnmar[i].label);
	    }
	  fclose(fpmo);
	}

      if( verb )
	{
	  for( i=0 ; i<MAXSHIFT ; i++)
	    {
	      printf("%d \t",i);
	      for( t=0 ; t < (akfval[i]-min)*70.0/(max - min) ; t++)
		{
		  printf("*");
		}
	      printf("%s\n", i == mat ? "<--" : "");
	    }
	}
    }

}

void swap_short(short* s,int anz)
{
  // swappen
  register char* cp, temp;
  register int n;
    
  cp= (char*)s;

  for(n=0 ; n< anz ; n++) // unbedingt noch als inline-fkt
    {
      temp=cp[0];
      cp[0]=cp[1];
      cp[1]=temp;
      cp+=2;
    }
}

CsignalFile* newSignalFile(char* filename)
{
  char body[20],ext[5];
  CsignalFile* nsf = new CsignalFile;
  short * buffer;

  char* fnp = strrchr(filename,'/');
  fnp = fnp == NULL ? filename : fnp + 1;

  if( sscanf(fnp,"%[^.].%s",&body,&ext) != 2 )
    {
      fprintf(stderr,"need filename body + extension\n");
      delete nsf;
      return NULL;
    }

  if( !strcmp( ext ,"16") )
    {
      nsf->coding = CODING_LINEAR;
      nsf->samplenbytes = 2;
    }
  else if( !strcmp(ext,"al") )
    {
      nsf->coding = CODING_ALAW;
      nsf->samplenbytes = 1;
    }
  else
    {
      fprintf(stderr,"unrecogized extension: %s\n",ext);
      delete nsf;
      return NULL;
    }

  nsf->openFile(filename);
  return nsf;
}

int readSignalFile(CsignalFile* sfp,short* buf,int center,int nsamp)
{

  if( sfp->coding == CODING_ALAW )
    {
      if( sfp->getData(buf,center*8 - nsamp/2,nsamp) !=
	  nsamp )
	{
	  fprintf(stderr,"Error getting data\n");
	  return 0;
	}
    }
  else if (sfp->coding == CODING_LINEAR )
    {
      int tpo = 2;
      double a[] = { 0.3356,0.6712,0.3356 };
      double b[] = { 0.2564,0.0860 };
      int edgeadd = 50;
      short stmpbuf[2*nsamp + 2*edgeadd];
      double bufftmp[2*nsamp + 2*edgeadd];
      int i,t;

      if( sfp->getData(stmpbuf,center*16 - nsamp - edgeadd ,2*nsamp + 2*edgeadd) !=
	  2*nsamp + 2*edgeadd )
	{
	  fprintf(stderr,"Error getting data\n");
	  return 0;
	} 
      for( t=0 ; t<2*nsamp +2*edgeadd ; t++ )
	{
	  bufftmp[t] = 0.0;
	}

      for( t=tpo ; t<2*nsamp +2*edgeadd; t++ )
	{
	  for( i=0 ; i<=tpo ; i++)
	    {
	      bufftmp[t] += a[i] * stmpbuf[t-i];
	    }
	  for( i=1 ; i<=tpo ; i++)
	    {
	      bufftmp[t] += b[i-1] * bufftmp[t-i];
	    }
	}

      for( t=edgeadd ; t < 2*nsamp + edgeadd ; t+=2 )
	{
	  buf[(t-edgeadd)/2] = (short)bufftmp[t];
	}
    }
  return nsamp;
}


