###################
# synrueck_par.pl #
###################

#by Uwe Reichel, 2001
#translates from BAS to NEGRA, 
#using the par-files, whose absolute paths are specified in 'infiles.txt' 


##################################### main ###################################

&inform;

if (<STDIN> =~ /\n/) {
  &path_input;
  for $pf (0 .. $#path) {
    &var_prepare;
    &par_input;
    until ($already == $#trenner) {
      &teilwortarray;
      &wortextrakt;
      &lexical;
      &nummerierung_ini;
      &mutter_ini;
      &ausgabe;
      &loesch;
      $already++;
    }
    print "generated: $outfile\n";
  }
}



####################################### subs ##################################

#sub inform

sub inform {
  print "\nThis program transforms the ORT, LEX, SYN and FUN-tier of the BAS-partiture into a NEGRA-file.\n";
  print "Please create a file 'infiles.txt' containing the absolute paths to the files which shall be transformed.\n";
  print "After having done this continue with <Return>\n";
  #print "\nDiese Programm bersetzt die ORT, LEX, SYN und FUN-Spur der BAS-Partitur ins NEGRA-Format.\n";
  #print "Hierzu mu zunchst eine Datei 'infiles.txt' angelegt werden, die die absoluten Pfade hin zu \n";
  #print "den gewnschten Files enthlt.\n";
  #print "Anschlieend weiter mit Return\n";
}


#sub path_input
#reads paths from 'infile.txt'

sub path_input {
  open(D,"infiles.txt") || die "Create a file 'infiles.txt' which contains the absolute paths to the wanted files\n";
  while(<D>) {
    chomp;
    if ($_ =~ /\/.+/) {
      push(@path,$_);
    }
  }
  close(D);
}


#sub parinput
#reads par-file
#segmentation by sentences (effecuated by @trenner)
#words of ORT-tier are combined with lexical-/syntactical categories
#and grammatical functions

sub par_input {
  if ($path[$pf] =~ /.*\/(.+)$/) {
    $infile=$1;
    if ($1 =~ /(.+?)\..*/) {
      $outfile=$1.".neg";
    }
  }
  open(OUT,">$outfile") || die "no output file\n";
  print OUT "\#FORMAT 3\n\n%%word\t\ttag\t\tmorph\t\tedge\t\tparent\t\tsecedge comment\n\n";
  close(OUT);
  open(D,"$path[$pf]") || die "not found\n";
  while(<D>) {
    chomp;
    $baum = $_;
    if ($baum =~ /ORT:[0-9\s]+(.+)/) {
      push (@ortspur,$1);
    }
    elsif ($baum =~ /TR2:\s+([0-9]+).+?(\.|\?|\<\*T\>t).*/) {
      $satzende{$1}=1;
    }
    elsif ($baum =~ /(LEX|SYN|FUN).+/){
      push(@turn, $baum);
    }
  }
  close(D);
  for $u (0 .. $#turn) {
    if ($turn[$u] =~ /LEX.+/){
      $turn[$u] =~ s/LEX\:\s+//;
      @lexik = split (/\s+/,$turn[$u]);
      $buffer=$lexik[0];
      $elem =   $ortspur[$buffer].$lexik[0]."_".$lexik[1]."0"; #concatenation vs ambiguity: word.wordnumber._.index.phraselength
      $kategorie{$elem} = $lexik[2];
      $lexikal{$elem} = 1;   #needed for node numbers
    }
    elsif ($turn[$u] =~ /FUN.+/){
      $turn[$u] =~ s/FUN\:\s+//;
      @funkt = split (/\s+/,$turn[$u]);
      @wl = split (/,/, $funkt[0]);
      foreach $eleme(@wl){
	$buffer=$eleme;
	$eleme = $ortspur[$buffer].$eleme."_".$funkt[1].$#wl;
	$funktion{$eleme} = $funkt[2];
      }
      push @wortliste, [ @wl ];
      if (defined $satzende{$buffer}) {
	if ($buffer == $buffer_old) {
	  $list_end=$#wortliste;
	}
	else {
	  if ($buffer_old != -1) {
	    push(@trenner, $list_end);
	  }
	  $buffer_old=$buffer;
	  $list_end=$#wortliste;
	}
      }
    }
    elsif ($turn[$u] =~ /SYN.+/){
      $turn[$u] =~ s/SYN\:\s+//;
      @synt = split (/\s+/, $turn[$u]);
      @synlist = split (/,/,$synt[0]);
      foreach $elemen(@synlist){
	$buffer=$elemen;
	$elemen = $ortspur[$buffer].$elemen."_".$synt[1].$#synlist;
	$kategorie{$elemen} = $synt[2];
      }
    }
  }  
  if ($trenner[$#trenner] != $#wortliste) {
    push(@trenner,$#wortliste);
  }
} 



#sub var_prepare
#prepares variables for current loop

sub var_prepare {
  @turn=();
  @trenner=("-1");
  $defined=1;
  $buffer_old = -1;
  $already=0;
  foreach $key (keys %satzende) {
    delete $satzende{$key};
  }
  @ortspur=();
  @wortliste=();
  $tellme=0;
}



#sub teilwortarray
#all lexical and syntactical information of one sentence is stored
#as one list of @@teilwortliste

sub teilwortarray {
  for $z ($trenner[$already]+1 .. $trenner[$already+1]) {
    push @teilwortliste , [ @{$wortliste[$z]} ];
  }
}



#sub wortextrakt
#extracts word, word.wordnumber and wordnumber
#  --> %wort
#  --> %wortexp
#  --> %wortnr

sub wortextrakt {
  for $u (0 .. $#teilwortliste){
    for $v (0 .. $#{ $teilwortliste[$u] }){
      if ($teilwortliste[$u][$v] =~ /(\D+)(\d+)_(\d+)/){
	$wort{$teilwortliste[$u][$v]} = $1;
	$wortexp{$teilwortliste[$u][$v]} = $1.$2;
	$wortnr{$teilwortliste[$u][$v]} = $2;
      }
    }
  }
}


#sub lexical
#removes terminal nodes from @@teilwortliste to write them into @ausg

sub lexical {
  for $lz (0 .. $#teilwortliste){
    if (defined $lexikal{$teilwortliste[$lz][0]}){
      push @ausg, [@{$teilwortliste[$lz]}];
    }
    else {
      push @buffer, [@{$teilwortliste[$lz]}];
    }
  }
  @teilwortliste = ();
  for $az (0 .. $#buffer){
    push @teilwortliste, [@{$buffer[$az]}];
  }
  @buffer = ();
}


#sub nummerierung_ini
#calls rekursively sub nummerierung

sub nummerierung_ini {
  $nummer = 500;
  while ($#teilwortliste >= 0){  
    &nummerierung;
  }
}


#subs nummerierung, beding, beding_b
#remove those lists of @@teilwortliste which have following characteristics:
#a)the first word appears for the first time in this position
#b)there's no shorter list, that contains this word (sub beding)
#c)if the list is discontinuous, it does not enclose any other list,
#  that is still contained in @@teilwortliste (sub beding_b)
#and appends it to @@ausg
#via %knoten its elements get the respective current node number

sub nummerierung{
  for $lz (0 .. $#teilwortliste) {
    if ($lz == 0) {
      &beding;
      &beding_b;
      if ($wahr == 1 && $wahr_b == 1) {
	for $y (0 .. $#{ $teilwortliste[$lz] }){
	  if (not defined $knoten{$teilwortliste[$lz][$y]} ){
	    $knoten{$teilwortliste[$lz][$y]} = $nummer;
	  }
	}
	$nummer++;
	push @ausg, [@{ $teilwortliste[$lz] }];
	push @entf, [@{ $teilwortliste[$lz] }];
      }
      else {
	push @buffer, [@{ $teilwortliste[$lz] }];
      }
    }
    else {
      if ($wortexp{$teilwortliste[$lz][0]} ne $wortexp{$teilwortliste[$lz-1][0]}) {
	&beding;
	&beding_b;
	if ($wahr == 1 && $wahr_b == 1) {
	  for $y (0 .. $#{ $teilwortliste[$lz] }){
	    if (not defined $knoten{$teilwortliste[$lz][$y]}){
	      $knoten{$teilwortliste[$lz][$y]} = $nummer;
	    }
	  }
	  $nummer++;
	  push @ausg, [@{ $teilwortliste[$lz] }];
	  push @entf, [@{ $teilwortliste[$lz] }];
	}
	else {
	  push @buffer, [@{ $teilwortliste[$lz] }];
	}
      }
      else {
	push @buffer, [@{ $teilwortliste[$lz] }];
      }
    }
  }
  @teilwortliste = ();
  for $z (0 .. $#buffer){
    push @teilwortliste, [@{ $buffer[$z] }];
  }
  @buffer = ();
  @entf = ();
}


sub beding{
  for $h ($lz+1 .. $#teilwortliste){
    if (not defined $lexikal{$teilwortliste[$h][0]}){
      if ($#{ $teilwortliste[$lz] } > $#{ $teilwortliste[$h] }){
	for $g (1 .. $#{ $teilwortliste[$lz] }){
	  for $i (0 .. $#{ $teilwortliste[$h] }){
	    if ($wortexp{$teilwortliste[$lz][$g]} eq $wortexp{$teilwortliste[$h][$i]}){
	      $wahr=0;
	      return $wahr;
	    }
	  }
	}
      }
    }
  }
  $wahr=1;
  return $wahr;
}


sub beding_b {
  if ($wortnr{ $teilwortliste[$lz][$#{ $teilwortliste[$lz] }] } - $wortnr{ $teilwortliste[$lz][0] } > $#{ $teilwortliste[$lz] }) {
    for $q ($lz+1 .. $#teilwortliste){
      if ($wortnr{$teilwortliste[$q][0]} > $wortnr{$teilwortliste[$lz][0]} && $wortnr{$teilwortliste[$q][0]} < $wortnr{ $teilwortliste[$lz][$#{ $teilwortliste[$lz] }] }) {
	$wahr_b = 0;
	return $wahr_b;
      }
    }
  }
  $wahr_b = 1;
  return $wahr_b;
}


#sub mutter_ini
#calls sub mutter iteratively

sub mutter_ini {
  for $o (0 .. $#ausg){
    &mutter;
  }
}


#sub mutter
#finds mother node and stores it in %mutter

sub mutter {
  for $v ($o+1 .. $#ausg){
    for $w (0 .. $#{ $ausg[$v] }){
      if ($wortexp{$ausg[$o][0]} eq $wortexp{$ausg[$v][$w]}){
	$mutter{$ausg[$o][0]} = $knoten{$ausg[$v][$w]};
	return $mutter{$ausg[$o][0]};
      }
    }
  }
  if (not defined $mutter{$ausg[$o][0]}){
    $mutter{$ausg[$o][0]}=0;
  }
}
  

#sub ausgabe
#output

sub ausgabe {
  open(OUT,">>$outfile");
  $buffer=$already+1;
  print OUT "\#BOS $buffer\n";
  for $i (0 .. $#ausg){
    if (defined $lexikal{$ausg[$i][0]}){
      print OUT "$wort{$ausg[$i][0]}\t\t$kategorie{$ausg[$i][0]}\t\t--\t\t$funktion{$ausg[$i][0]}\t\t$mutter{$ausg[$i][0]}\n";
    }
    else {
      print OUT "\#$knoten{$ausg[$i][0]}\t\t$kategorie{$ausg[$i][0]}\t\t--\t\t$funktion{$ausg[$i][0]}\t\t$mutter{$ausg[$i][0]}\n";
    }
  }
  print OUT "\#EOS $buffer\n";
  close(OUT);
}


#sub loesch

sub loesch {
  @ausg=();
}




