/***********************************************************************
************************************************************************

Module		: test_phondats-3.2
Title		: testing a group of phondat files

Author		: F. Schiel
Datum/Aenderung : 19.03.93 / 24.06.98

Description	: 
Ported to Linux. Using linux_audio for output (bad quality!).
Takes all filenames from command line that are not icsiargs, test each 
of them for being a speech file in either the Phondat 1 or 2 format.
If a file ist not conform with that format, it prints a error message
what's wrong in wich file to stderr and continues.
If all files are ok the exit code is 0, else the exit code is the number
of found corrupted files, or -1 if there is a sever error..


Usage:
test_phondats [v=yes][f=1|2][p=yes][port=0] file1 [file2 ...]

v=yes : prints infos found in each file to stdout (default=no)
f=1|2 : if given, tests for Phondat 1 or 2 only 
              (default: accepts both formats).
p=yes : plays signal to audio device
port=0|1 : 0 = speaker, 1 = headphone, 2 = line out
vol=0.0-1.0 : audio volume factor
precise=0 : 0 = tolerates most not severe errors
            1 = reports  * incorrect filelength
                         * Sex not one of W,w,M,m
                         * Sprk is empty
                         * Words is zero
                         * Day is within 1 - 31
                         * Month is not within 1 - 12
                         * Year is not within 1950 - 2050
                         * Flagtype is not -32000
                         * Flaginit is not 32149
                         * Filename is not matching
                         * # of header blocks not equal 1 in version 1


Linking modules or libraries:
ipkclib,m

Contained functions:
			: 

*************************************************************************/
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <ipkclib.h>

/* DEFINES, only used within this module ********************************/
# define VOLUME 1.0           /* Default Laustaerke 0.0 ... 1.0 */
# define PORT 0           /* Default Ausgabeport: 0 = speaker, 1 = headphone */


/* TYPE DEFINITIONS, only used within this module  **********************/


/* GLOBAL VARIABLES (avoid, if possible !) ******************************/


/* FUNCTION PROTOTYPES, capsuled in this module *************************/

main(int argc,const char **argv)
{
	char 	filenam[400],newfilenam[400],input[400],outstr[800],
	        filenamupper[400],filenamlower[400],
		*ortho = NULL,
		*cano = NULL,
		*appname,
		*cptr;
	short   *data,k;
	int	ret,i,samples;
        int 	verb = 0;
 	int	type = 0;
 	int	play = 0;
 	int	precise = 0;
        int     port = PORT;
 	int	corrupt = 0;
	long	filesize;
	float	volume = VOLUME;
	FILE	*file,*newfile;
	Phon_header_2 	*header;
	icsiargtab_t args[] =
        {
          { 0, "3.2 : Testing all files from command line for being files in PhonDat format", ARG_DESC},
          { "v","verbose (FALSE)", ARG_BOOL, &verb },
	  { "f","Format type definition (NONE)", ARG_INT, &type },
	  { "p","play signal to audio (FALSE)", ARG_BOOL, &play },
	  { "port","audio port (0:speaker, 1:headphone, 2:lineout)", ARG_INT, &port },
	  { "vol","volume factor (0,0 - 1,0)", ARG_FLOAT, &volume },
	  { "precise","gives all errors", ARG_BOOL, &precise },
	  {0,0,0}
	};

  /* Test for icsiargs if any */
  icsiargs(args,&argc,&argv,&appname);
  if(verb) printargs(stdout,appname,args);
  if(argc < 1)
    {
    fprintf(stderr,"usage: %% %s [v=yes][f=1|2][p=yes][port=0][vol=0,8][precise=0] file1 [file2 ...]\n",appname);
    exit(-1);
    }
  #ifdef LINUX
  if(port != 0)
  {
    fprintf(stderr,"%s: other ports than 0 not implemented in LINUX\n",
            appname);
    port=0;
  }
  #endif
  for(k=0;k<argc;k++)
  {
  strcpy(filenam,argv[k]);
    if(verb) printf("%s: File = %s\n",appname,filenam);
    if((file = fopen(filenam,"r")) == NULL)
    {
	fprintf(stderr,"%s: cannot open file %s\n",appname,filenam);
	perror(appname);
	corrupt++;
        continue;
    }
#ifdef LINUX
    if((header = read_header_vms(file,&ortho,&cano)) == NULL)
#endif
#ifdef SUNOS
    if((header = read_header_sun(file,&ortho,&cano)) == NULL)
#endif
      {
      fprintf(stderr,"%s: error - no phondat header in file %s\n",
              appname,filenam);
      corrupt++;
      }
    else 
      {
      if(verb) disp_header_v2(header);
      /* test for correct version */
      switch (type)
        {
        case 0:
        if((header->version != 1) && (header->version != 2))
          {
          fprintf(stderr,"%s: file %s - VERSION not set correct (%d)\n",appname,filenam,header->version);
          corrupt++;
          }
        break;
        case 1:
        if(header->version != 1) 
          {
          fprintf(stderr,"%s: file %s has not a phondat 1 header as exspected (%d)\n",appname,filenam,header->version);
          corrupt++;
          }
        break;
        case 2:
        if(header->version != 2) 
          {
          fprintf(stderr,"%s: file %s has not a phondat 2 header as exspected (%d)\n",appname,filenam,header->version);
          corrupt++;
          }
        if(ortho == NULL)
          {
          fprintf(stderr,"%s: file %s has a phondat 2 header, but orthography is empty\n",appname,filenam);
          corrupt++;
          }
        if(cano == NULL)
          {
          fprintf(stderr,"%s: file %s has a phondat 2 header, but canonical form is empty\n",appname,filenam);
          corrupt++;
          }
        break;
        default:
        fprintf(stderr,"%s: error - unknown option f = %d\n",appname,type);
        exit(-1);
        }
      /* check for certain finicky extras */
      if(precise)
        {
        if((cptr = strrchr(filenam,'/')) == NULL) cptr = filenam;
        else cptr++;
        for(i=0;i<strlen(cptr);i++) 
          {
          if(isalpha(cptr[i]))
            {
            filenamupper[i] = toupper(cptr[i]);
            filenamlower[i] = tolower(cptr[i]);
            }
          else
            {
            filenamupper[i] = cptr[i];
            filenamlower[i] = cptr[i];
            }
          }
        filenamlower[i] = '\0';
        filenamupper[i] = '\0';
      /*  fprintf(stderr,"%s: filenamupper = %s, filenamlower = %s\n",
                appname,filenamupper,filenamlower);  */
        if((strcmp(filenamupper,header->ifl) != 0) &&
           (strcmp(filenamlower,header->ifl) != 0) )
          {
          fprintf(stderr,"%s: File %s - FILENAME %s is not correct\n",appname,filenam,header->ifl);
          corrupt++;
          }
        if(!isalnum(header->sprk[0]) || !isalnum(header->sprk[1]))
          {
          fprintf(stderr,"%s: File %s - SPRK may not set correct\n",appname,filenam);
          corrupt++;
          }
        if((header->sex != 'm') && (header->sex != 'w') && 
           (header->sex != 'M') && (header->sex != 'W'))
          {
          fprintf(stderr,"%s: File %s - SEX is not set to m,M,w,W\n",appname,filenam);
          corrupt++;
          }
        if(((int)header->day < 1) || ((int)header->day > 31))
          {
          fprintf(stderr,"%s: File %s - DAY is out of range\n",appname,filenam);
          corrupt++;
          }
        if(((int)header->month < 1) || ((int)header->month > 12))
          {
          fprintf(stderr,"%s: File %s - MONTH is out of range\n",appname,filenam);
          corrupt++;
          }
        if((header->year < 1950) || (header->year > 2050))
          {
          fprintf(stderr,"%s: File %s - YEAR is out of range\n",appname,filenam);
          corrupt++;
          }
        if(header->words < 0)
          {
          fprintf(stderr,"%s: File %s - WORDS is negativ\n",appname,filenam);
          corrupt++;
          }
        if((header->adc_bits < 0) || (header->adc_bits > 4))
          {
          fprintf(stderr,"%s: File %s - ADC_BITS out of range\n",appname,filenam);
          corrupt++;
          }
        if(header->flagtype != -32000)
          {
          fprintf(stderr,"%s: File %s - FLAGTYPE is not set to -32000\n",appname,filenam);
          corrupt++;
          }
        if(header->flaginit != 32149)
          {
          fprintf(stderr,"%s: File %s - FLAGINIT is not set to 32149\n",appname,filenam);
          corrupt++;
          }
        if((header->version == 1) && (header->anz_header != 1))
          {
          fprintf(stderr,"%s: File %s - ANZ_HEADER is not set to 1 in version 1 file\n",appname,filenam);
          corrupt++;
          }
        }
      /* check for dynamic part of header */
      if(verb && (ortho != NULL)) printf("%s: orthographic text: \n %s \n",appname,ortho);
      if(verb && (cano != NULL)) printf("%s: canonical text: \n %s \n",appname,cano);
      fseek(file,0,0);
#ifdef LINUX
      if((data = read_data_vms(header,&samples,file)) == NULL) 
#endif
#ifdef SUNOS
      if((data = read_data_sun(header,&samples,file)) == NULL) 
#endif
        {
        fprintf(stderr,"%s: error - cannot read samples in file %s\n",
                appname,filenam);
        corrupt++; 
        cfree((char *)header);
        continue;
        }          
      if(verb) printf("%s: number of speech samples: %d\n",appname,samples);
      /* check for correct length of file */
      fseek(file,0,2);
      filesize = ftell(file);
      if(filesize < ((header->nspbk + header->anz_header) * 512))
        {                                                              
        fprintf(stderr,"%s: error - number of blocks more than size in file %s\n", 
                appname,filenam);                                      
        corrupt++;                                                     
        }
      if(precise && (filesize > ((header->nspbk + header->anz_header) * 512)))
        {                                                              
        fprintf(stderr,"%s: error - number of blocks less than size in file %s\n", 
                appname,filenam);                                      
        corrupt++;                                                     
        }
      if(play)
      {
#ifdef SUNOS
        if(!sparc_audio(data,samples,header->isf,(double)volume,port))
        {
        fprintf(stderr,"%s: could not output to audio device\n",appname);
        exit(-1);
        }
#endif
#ifdef LINUX
        if(linux_audio(data,2*samples,DSP_TYPE_LINEAR_16,header->isf,volume) != DSP_NO_ERROR)
        {
          fprintf(stderr,"%s: could not send data to linux audio card (error %d)\n", appname,ret);
          exit(-1);
        }
#endif
      }
      cfree((char *)data);
      cfree((char *)header);
      if(ortho != NULL) cfree(ortho);
      if(cano != NULL) cfree(cano);
      }
    fclose(file);
  } /* ende schleife ueber argumente */
  return(corrupt);
}
