#include "CCexceptions.h"
#include "Cverklist.cc"
#include "CfileIO.h"
#include "Cdocsys.h"
#include "iotoolbox.h"
#include "Ctreefind.h"

static char inventar[] = "symbol-inventar.txt";
static char ignch[] = "-, _";

template class Cverklist<Treenode*>;
template class Clistel<Treenode*>;

void dumpnode(Treenode* dumpnode,char* pre,char** invent,int anzinv);

main(int argc,char** argv)
{
  char* appname,*inventfile = inventar,line[1000],**inventar,*sstrfile=NULL,
    *ifile=NULL,
    *cp;
  int anzinv,k,i,j,nerg;
  CfileIO ssfio;
  int symlist[50];
  int anzsymb;
  Treenode* tnp,**tnpp,*spp,**ergarr;
  Cverklist<Treenode*> erglist;
   
  icsiargtab_t args[] =
  {
    {"iv","inventar-file",ARG_STR,&inventfile},
    {"sstr","searchstring-file",ARG_STR,&sstrfile,ARG_REQ},
    {"ign","ignorechars",ARG_STR,&ignch},
    {0,0,0}
  }; 
   
  try
    {
      // Start of code
      icsiargs(args,&argc,&argv,&appname);
         
      if( (anzinv = readInventar(inventfile,&inventar)) < 0 )
	{
	  failure(__FILE__,__LINE__,"Error reading Inventar from %s",
		  inventfile);
	}
      
      Ctreefind tf(anzinv);

     
      if( sstrfile == NULL || ssfio.openRead(sstrfile) < 0 )
	{
	  failure(__FILE__,__LINE__,"Error opening %s",sstrfile);
	}

      while( ssfio.getNextLine(line) > 0 )
	{
	  if( !sscanf(line,"%s",line) )
	    {
	      continue;
	    }

	  anzsymb=0;
	  for( cp=line + strspn(line,ignch); 
	       cp - line < strlen(line) ; cp += strspn(cp,ignch) )
	    {
	      for(k=0;k<anzinv;k++)
		{
		  if( strncmp(inventar[k],cp,strlen(inventar[k])) == 0) 
		    {
		      symlist[anzsymb++] = k;
		      cp += strlen(inventar[k]);
		      break;
		    }
		  
		}

	      if(k == anzinv)
		{
		  failure(__FILE__,__LINE__,"..%s not in Inventar",cp);
		}
	    }
	  //in den Baum
	  tf.inTree(symlist,anzsymb);
	}
    
      tf.compact();

      while( gets(line) > 0 )
	{
	  if( line[0] == '\n' )
	    {
	      tf.initSearch();
	    }

	  for( cp=line + strspn(line,ignch);
	       cp - line < strlen(line)  && *cp != '\n' ;
	       cp += strspn(cp,ignch))
	    {
	      
	     for(k=0;k<anzinv;k++)
	       {
		 if( strncmp(inventar[k],cp,strlen(inventar[k])) == 0) 
		   {
		     cp += strlen(inventar[k]);
		     break;
		   }
		  
		}

	     if(k == anzinv)
	       {
		 failure(__FILE__,__LINE__,"..%s not in Inventar",cp)
	       }
	     

	     //propagate searchpoints
	     tf.propagateSearch(k);
	   }
       }
     
     for( tnpp = tf.leafs.skipThru(init);
	  tnpp != NULL ;
	  tnpp = tf.leafs.skipThru(next) )
       {
	 for( tnp=*tnpp ; tnp != NULL ; tnp=tnp->thepre )
	   {
	     erglist.addIniEl(&tnp);
	   }
	 nerg = erglist.compact(&ergarr);
	 erglist.clear();
	 for( k=0 ; k<nerg ; k++ )
	   {
	     printf("%s%s",k==0 ? "" : ",",inventar[ergarr[k]->symbol]);
	   }
	 printf(" %d\n",(*tnpp)->anz);
	 delete [] ergarr;
       }
     
     // End of code 
    }
  catch(Ausnahme& a)
    {
      switch( a.code )
	{
	default:
	  fprintf(stderr,"%s %d : %s\n",a.file,a.line,a.message);
	  exit(1);
	}
    }
  catch(...)
    {
      exit(2);
    }
}


void dumpnode(Treenode* dn,char* pre,char** invent,int anzinv)
{
  char kontext[50];
  Treenode **dnpp;
  Clistel<Treenode*> *skipvar;

  sprintf(kontext,"%s%s",pre,invent[dn->symbol]);
  printf("%s : %d\n",kontext,dn->anz);

  for( dnpp = dn->succvl.skipThru(init,&skipvar);
       dnpp != NULL ;
       dnpp = dn->succvl.skipThru(next,&skipvar) )
    {
      dumpnode( *dnpp,kontext,invent,anzinv);
    }
}
  
