
BEGIN {
    anztt = readtranstab( "'$transtab'",trtab );
    print "read transtab with " anztt " entries"
  while( getline < "'kfreq'" > 0 )
    {
      if( $2 == 0 )
        {
          continue
        }
      #kontext mit - abtrennen
      n=split( $1 , syms , "," )
      lk = syms[1]
      rk = syms[n]
      l=""
      for( i=2 ; i<=n-1 ; i++ )
        {
          l = l (l=="" ? "" : ",") syms[i]
        }
      kts_c[lk "-" l "-" rk] += $2
    }
}
{

  rule[$2] += $1
  split($2,pts,"-")
  rulek[pts[1] "-" pts[2] "-" pts[4]] += $1
}

END {
  for( r in rule)
    {
      split( r,rpts,"-" )
      if( rulek[ rpts[1] "-" rpts[2] "-" rpts[4] ] == 0 )
        {
          print "fatal: zero freq rulek " rpts[1] "-" rpts[2] "-" rpts[4]
        }
      rule[ r ] = (rule[r] - disrule)/rulek[ rpts[1] "-" rpts[2] "-" rpts[4] ]
      if( kts_c[ rpts[1] "-" rpts[2] "-" rpts[4] ] == 0 )
        {
          print "fatal: zero freq kts_c " rpts[1] "-" rpts[2] "-" rpts[4]
        }
      cellwk[ rpts[1] "-" rpts[2] "-" rpts[4] ] = (rulek[rpts[1] "-" rpts[2] "-" rpts[4]] - discan)/kts_c[rpts[1] "-" rpts[2] "-" rpts[4]]
    }
  for( r in rule )
    {
      split(r,pts,"-")
      pts[2] = pts[2] == "_" ? "" : pts[2]
      pts[3] = pts[3] == "_" ? "" : pts[3]
      printf("%s",translate(pts[1])) > "'$rulout'"
      nsyms=split(pts[2],syms,",")
      for( i=1 ; i<=nsyms ; i++)
       {
         printf(",%s",translate(syms[i])) > "'$rulout'"
       }
      printf(",%s>%s",translate(pts[4]),translate(pts[1])) > "'$rulout'"
      nsyms=split(pts[3],syms,",")
      for( i=1 ; i<=nsyms ; i++)
       {
         printf(",%s",translate(syms[i])) > "'$rulout'"
       }
      printf(",%s %f %f\n",translate(pts[4]),log(rule[r]) + log(cellwk[pts[1] "-" pts[2] "-" pts[4]]), 0.0) > "'$rulout'"
    }

}
#
# description: read a translation table
#
function readtranstab(filename, transtab, i)
{
  i=0
  while( getline < filename  >0 )
    {
      transtab[$1] = $2;
      i++
    }
  return i;
}
function translate( sym )
{
  if( sym in trtab )
    {
      return trtab[sym]
    }
  else
    {
      return sym
    }
}
