/***********************************************************************
************************************************************************

Module		: extract_phondat_ortho
Title		: extract the orthographie from a phondat 2 file

Author		: F. Schiel
Datum/Aenderung : 29.03.95 / 

Description	: 
Takes all phondat files from command line, tests them for being a
PhonDat file format 2, extracts the orthographic string and
prints it to stdout with one CR after it.
If a file is not a phondat file or has not a phondat 2 header,
this file will be skipped, an error message is printed
to stderr and the return code is rised by 1.
If no error occurs, the return code is 0.

Usage:
cat phondat_2.file | extract_phondat_ortho > ortho.file


Linking modules or libraries:
ipkclib

Contained functions:
			: 

*************************************************************************/
# include <stdio.h>
# include <ipkclib.h>

/* DEFINES, only used within this module ********************************/
#define NUMBERBEGIN 4
#define NUMBEREND 7

/* TYPE DEFINITIONS, only used within this module  **********************/


/* GLOBAL VARIABLES (avoid, if possible !) ******************************/


/* FUNCTION PROTOTYPES, capsuled in this module *************************/

main(int argc,const char **argv)
{
	char 	filenam[40],input[40],
		*ortho,
		*cano,
		*appname;
	int	i,k,l,corrupt=0;
	int	verb=0;
	int	print=0;
	FILE    *file;
	Phon_header_2 	*header = NULL;
	icsiargtab_t args[] =
        {
          { 0, "Extractin g the orthography from a PhonDat 2 file", ARG_DESC},
          { "v","verbose (FALSE)", ARG_BOOL, &verb },
          { "p","print leading file number (FALSE)", ARG_BOOL, &print },
	  {0,0,0}
	};

  /* Test for icsiargs if any */
  icsiargs(args,&argc,&argv,&appname);
  for(k=0;k<argc;k++)
  { 
    strcpy(filenam,argv[k]);
    if(verb) fprintf(stderr,"%s: File = %s\n",appname,filenam);
    if((file = fopen(filenam,"r")) == NULL)
    {
      fprintf(stderr,"%s: cannot open file %s\n",appname,filenam);
      perror(appname);
      corrupt++;
      continue;
    }
    if(verb) fprintf(stderr,"%s: Opened File = %s\n",appname,filenam);
    if((header = read_header_sun(file,&ortho,&cano)) == NULL)
      {
      fprintf(stderr,"%s: error - no phondat header in file %s\n",
              appname,filenam);
      if(header != NULL) cfree((char *)header);
      corrupt++;
      continue;
      }
    else 
      {
      /* test for orthography */
    if(verb) fprintf(stderr,"%s: Testing for ortho\n",appname);
      if(ortho == NULL)
        {
        fprintf(stderr,"%s: file %s has a phondat header, but orthography is empty\n",appname,filenam);
        cfree((char *)header);
        corrupt++;
        continue;
        }
      else
        {
      /* if print is set extract utterance number from filename and print
         it to stdout */
        if(print)
          {
          for(l=NUMBERBEGIN;l<NUMBEREND;l++) putchar(filenam[l]);
          putchar('\t');
          }
      /* print orthography to stdout */
        if(verb) fprintf(stderr,"%s: ortho:\n %s \n",appname,ortho);
        if(verb) fprintf(stderr,"%s: cano:\n %s \n",appname,cano);
        printf("%s\n",ortho);
        }
      }
    cfree((char *)header);
    if(verb) fprintf(stderr,"%s: cleaning up\n",appname);
    if(ortho != NULL) cfree(ortho);
    if(cano != NULL) cfree(cano);
    fclose(file);
  } /* ende schleife ueber argumente */
  return(corrupt);
}
