#!/usr/bin/perl -w
use XML::DOM;
use warnings;

# Schlssel fr alle verwendeten Mime-Typen. Wert ist ein Zwei-Werte-Array.
%mime = ("mimeClass" => "text", "mimeType" => "simpletext", "encoding" => "utf8", "track" => "");

## Bei Erweiterung um eine neue Tier: Hier eine entsprechende Zeile einfgen!
%formate = ("TR2" => ["tr2", "Verbmobil Transliteration II"],
            "KAN" => ["kan", "Canonical Pronunciation"],
            "ORT" => ["ort", "Orthography"],
            "TRL" => ["trl", "Verbmobil Transliteration I"],
            "SUP" => ["sup", "Superimposed Speech"],
            "PHO" => ["pho", "Phonetic Segmentation"],
            "SAP" => ["sap", "Phonetic Segmentation SAM-PA"],
            "MAU" => ["mau", "Automatic Phonetic Segmentation by MAUS"],
            "WOR" => ["wor", "Word Segmentation"],
            "DAS" => ["das", "Dialogact Segmentation"],
            "PRB" => ["prb", "Prosodic Segmentation"],
            "PRS" => ["prs", "Symbolic prosodic Segmentation"],
            "NOI" => ["noi", "Noise Labeling"],
            "LBP" => ["lbp", "Signal-based prosodic accents Labeling"],
            "LBG" => ["lbg", "Signal-based prosodic boundaries Labeling"],
            "PRO" => ["pro", "Syntactic-prosodic boundaries Labeling"],
            "SYN" => ["syn", "Syntactic categories"],
            "LEX" => ["lex", "Lexical categories"],
            "FUN" => ["fun", "Grammatical Function"],
            "POS" => ["pos", "Parts of Speech"],
            "LMA" => ["lma", "Lemmata"],
            "IPA" => ["ipa", "Phonetic Segmentation IPA"],
            "TRN" => ["trn", "Segmentation in turns"],
            "TRS" => ["trs", "Smartkom Transliteration"],
            "GES" => ["ges", "SmartKom Gesture Labeling"],
            "USH" => ["ush", "SmartKom User State Annotation (holistic)"],
            "USM" => ["usm", "SmartKom User State Annotation (mimic expression)"],
            "OCC" => ["occ", "SmartKom User State Labeling Occlusions"],
            "USP" => ["usp", "SmartKom Meta Linguistic Features"],
            );

exit(-1) and warn "usage: baf2ag.pl <filename>!" unless @ARGV;
# Umwandeln eines BAF-Files ins AGSet-Format
#foreach (@ARGV) {
$inputname = $ARGV[0];
open (FILE, $inputname) or exit(-1) and warn "$inputname konnte nicht geffnet werden!";
@content = <FILE>;

# Hauptarbeit leisten. Dafr knnte ich mir auch ein besseres Tool basteln... aus einer DTD
# ein Perl-Tool erzeugen, das daraus einen (leeren) Baum macht. Eine DTD ist parsebar...
$timeline_id_counter = 0;
$signal_id_counter = 1;
$ag_id_counter = 1;
#$ag_id_counter2 = 1;
$anchor_id_counter = 0;
$annotation_id_counter = 0;
$format = "";
undef $timeline;
undef $timeline2;
undef $ag;
undef $ann0;

# Anker mit Sample-Zeiten
%sample_anchors = ();

$doc = new XML::DOM::Document or exit(-1) and warn "XML-Dokument konnte nicht erzeugt werden!";
$doc->setXMLDecl($doc->createXMLDecl('1.0','UTF-8','yes'));
$doc->setDoctype($doc->createDocumentType('AGSet', 'ag.dtd'));
$root = $doc->createElement("AGSet");
$agsetid = $ARGV[0];
$agsetid =~ s/\.par//;
$agsetid =~ /([^\/]+)$/;
$root->setAttribute("id", "$1");
$root->setAttribute("version", "1.0");
$root->setAttribute("xmlns", "http://www.ldc.upenn.edu/atlas/ag/");
$root->setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
$root->setAttribute("xmlns:dc", "http://purl.org/DC/documents/rec-dces-19990702.htm");
$doc->appendChild($root);

# Verarbeitung des Headers
# Was passiert, wenn der Header fehlt?
$i = 0;
$meta = $doc->createElement("Metadata");
## Titel und so knnte man vielleicht noch setzen
while ($i <= $#content and $content[$i] !~ /^LBD:$/) {
    if ($content[$i] =~ /^([A-Z]{3}):\s*(.*)$/) {
        $ometa = $doc->createElement("OtherMetadata");
        $ometa->setAttribute("$1", "$2");
        $meta->appendChild($ometa);
    }
    $i++;
}
$root->appendChild($meta);
$exit_status = 0;
$i++;
unless ($content[$i]) { # Zeile "LBD:" berspringen
    warn "Daten unvollstndig!";
    exit(-1);
}

## Es gibt einen Zshg. zwischem AG-type, Annotation-type und Feature-name. Manchmal.

## Bei jedem Label-Wechsel eine nderung der Einheit machen? Neuen Tag anfangen?
# Verarbeitung der Spuren
while ($content[$i]) {
    unless ($content[$i] =~ /^GES/) {
        $content[$i] =~ s/\s*$//;
    }
    # erstmal nach Labels unterscheiden.
    if ($content[$i] =~ /^([A-Z2]{3}):\s*(.*)$/) {
        # Umformen in AG-XML mglich
        if ($1 eq "KAN") { # Eine Zahl, dann non-whitespace. KAN, ORT, LEX Listen unmglich?
            if ($2 =~ /^(\d+)\s*(\S+)$/) {
                $number = $1;
                $transcript = $2;
                &class1("KAN", $transcript, $number, $number + 1);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes KAN-Format. Korrekt wre: \\d+\\s*\\S+\n",
                "(Zahl, Wort in phonetischer Umschrift)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "ORT") { # Wie oben
            if ($2 =~ /^(\d+)\s*(\S+)$/) {
                $number = $1;
                $transcript = $2;
                &class1("ORT", $transcript, $number, $number + 1);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes ORT-Format. Korrekt wre: \\d+\\s*\\S+\n",
                "(Zahl, Wort in orthografischer Schreibweise)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "TRL") { # Liste von Zahlen, aber kein Whitespace
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(.*)$/) {
                $transcript = $2;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("TRL", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes TRL-Format. Korrekt wre: \\d+;\\d+|\\d+(,\\d+)*\\s*.*\n",
                "(Zahlenliste, Wort in TRL-Schreibweise (Verbmobil I))";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "TR2") { # dito
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(.*)$/) {
                $transcript = $2;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("TR2", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes TR2-Format. Korrekt wre: \\d+;\\d+|\\d+(,\\d+)*\\s*.*\n",
                "(Zahlenliste, Wort in TRL-Schreibweise (Verbmobil II))";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "SUP") { # Liste, utterance-id, Text
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(\S+)\s*(\S.*)$/) {
                $uttid = $2; # Ist das immer dasselbe File? Nein. Auch egal.
                $transcript = $3;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("SUP", $transcript, $start, $end);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "utterance-id");
                $feature->addText("$uttid");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes SUP-Format. Korrekt wre: (\\d+;\\d+|\\d+(,\\d+)*)\\s*\\S+\\s*\\S.*\n",
                "(Zahlenliste, Dateiname, Wort in TRL-Schreibweise (Verbmobil II))";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "PHO") { # Beginn, Dauer, Liste, Text
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+;\d+|\d+(?:,\d+)*)\s*(\S+)$/) {
                $begin = $1;
                $duration = $2;
                $list = $3;
                $transcript = $4;
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("PHO", $transcript, $start, $end);
                &class2("PHO", $transcript, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "contained_in");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes PHO-Format. Korrekt wre: \\d+\\s*\\d+\\s*(\\d+;\\d+|\\d+(,\\d+)*)\\s*\\S+\n",
                "(Zahl, Zahl, Zahlenliste, Label-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "SAP") { # dito
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+;\d+|\d+(?:,\d+)*)\s*(\S+)$/) {
                $begin = $1;
                $duration = $2;
                $list = $3;
                $transcript = $4;
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("SAP", $transcript, $start, $end);
                &class2("SAP", $transcript, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "contained_in");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes SAP-Format. Korrekt wre: \\d+\\s*\\d+\\s*(\\d+;\\d+|\\d+(,\\d+)*)\\s*\\S+\n",
                "(Zahl, Zahl, Zahlenliste, Label-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "MAU") { # nochmal
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+;\d+|\d+(?:,\d+)*|-1)\s*(\S+)$/) {
                $begin = $1;
                $duration = $2;
                $list = $3;
                $transcript = $4;
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                elsif ($3 eq "-1") { # Keine Zuordnung!
                    $start = $end = -1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("MAU", $transcript, $start, $end);
                &class2("MAU", $transcript, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "contained_in");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
                if ($3 eq "-1") { # Keine Zuordnung!
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "Warning");
                    $feature->addText("Keine Zuordnung!");
                    $annotation->appendChild($feature);
                }
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes MAU-Format. Korrekt wre: \\d+\\s*\\d+\\s*(\\d+;\\d+|\\d+(,\\d+)*|-1)\\s*\\S+\n",
                "(Zahl, Zahl, Zahlenliste, Label-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "WOR") { # ebenso
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+;\d+|\d+(?:,\d+)*|-1)\s*(.*)$/) {
                $begin = $1;
                $duration = $2;
                $list = $3;
                $transcript = $4;
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("WOR", $transcript, $start, $end);
                &class2("WOR", $transcript, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "equals");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes WOR-Format. Korrekt wre: \\d+\\s*\\d+\\s*(\\d+;\\d+|\\d+(,\\d+)*|-1)\\s*\\S+\n",
                "(Zahl, Zahl, Zahlenliste, Label-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "DAS") { # Liste, Marker-String (mit whitespace!)
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(.*)$/) {
                $transcript = $2;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("DAS", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes DAS-Format. Korrekt wre: \\d+;\\d+|\\d+(,\\d+)*\\s*.*\n",
                "(Zahlenliste, Marker-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "PRB") { # Integer, Liste, Marker-String
            if ($2 =~ /^(\d+)\s*(\d+;\d+|\d+(?:,\d+)*)\s*(.*)$/) {
                $sample = $1;
                $transcript = $3;
                if ($2 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $2;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("PRB", $transcript, $start, $end);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "sample");
                $feature->addText("$sample");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes PRB-Format. Korrekt wre: \\d+\\s*(\\d+;\\d+|\\d+(,\\d+)*)\\s*.*\n",
                "(Zahl, Zahlenliste, Marker-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "PRS") { # Liste, Marker-String (vorgegeben)
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(B[239]|EK|[PN]A)$/) {
                $transcript = $2;
                ## Verbesserung: Stattdessen oder zustzlich die "volle Version"
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("PRS", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes PRS-Format. Korrekt wre: \\d+;\\d+|\\d+(,\\d+)*\\s*(B[239]|EK|[PN]A)\n",
                "(Zahlenliste, Markerstring der Form: B3, B2, B9, PA, NA, EK)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "NOI") { # Integer/zwei mit ; und Marker-String
            ## Der Ausdruck ist vielleicht noch zu kompliziert.
            if ($2 =~ /^((?:\d+|-1);\d+|\d+)((?:\s*\<(?:A|B|P|\%|\#(?:|Klopfen|Knock|Rascheln|Rustle|Quietschen|Squeak|Mikrowind|Mikrobe|Klicken|Click)|Schmatzen|Smack|Schlucken|Swallow|R\"auspern|Throat|Husten|Cough|Lachen|Laugh|Ger\"ausch|Noise)\>)+)$/) {
                $transcript = $2;
                if ($1 =~ /^(?:\d+|-1);(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    $start = $1;
                    $end = $1 + 1;
                }
                $transcript =~ s/^\s*//;
                &class1("NOI", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes NOI-Format. Korrekt wre: ",
                "((?:\\d+|-1);\\d+|\\d+)\\s*<(A|B|P|%|#(|Klopfen|Knock|Rascheln|Rustle|Quietschen|Squeak|Mikrowind|Mikrobe|Klicken|Click)|Schmatzen|Smack|Schlucken|Swallow|R\"auspern|Throat|Husten|Cough|Lachen|Laugh|Ger\"ausch|Noise)>\n",
                "(Zahlenliste, Markerstring der Form: <A>, <B>, <P>, <%>, <#>, <#Klopfen>, ",
                "<#Knock>, <#Rascheln>, <#Rustle>, <#Quietschen>, <#Squeak>, <#Mikrowind>, ",
		"<#Mikrobe>, <#Klicken>, <#Click>, <Schmatzen>, <Smack>",
                " <Schlucken>, <Swallow>, <R\"auspern>, <Throat>, <Husten>, <Cough>, <Lachen>, ",
                "<Laugh>, <Ger\"ausch>, <Noise>)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "LBP") { # Integer, Marker-String
            if ($2 =~ /^(\d+)\s*(PA|NA|EK)$/) {
                $sample = $1;
                $transcript = $2;
                &class2("LBP", $transcript, $sample, $sample);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes LBP-Format. Korrekt wre: \\d+\\s*(PA|NA|EK)\n",
                "(Zahl, Markerstring der Form: PA, NA, EK)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "LBG") { # Integer, Marker-String
            if ($2 =~ /^(\d+)\s*(B(?:2|3|9|3QH|3QL))$/) {
                $sample = $1;
                $transcript = $2;
                &class2("LBG", $transcript, $sample, $sample);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes LBG-Format. Korrekt wre: \\d+\\s*B(2|3|9|3QH|3QL)\n",
                "(Zahl, Markerstring der Form: B2, B3, B9, B3QH, B3QL)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "PRO") { # Integer|zwei mit ; und Marker-String
            if ($2 =~ /^(\d+;\d+|\d+)\s*(SM1|SM2|SM3|SS1|SS2|SC2|SC3|PM1|PM3|PC2|LC2|LS2|RC1|RC2|RS2|EM3|FM3|DS1|DS3|AM2|AM3|AC1|IC0|IC1|IC2|IRX|IRN|IZB|IRB|IWE|TM2|IZE|TCA|IWN|IRE|TCL)$/) {
                $transcript = $2; # Die drei letzteren sind neu!
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    $start = $1;
                    $end = $1 + 1;
                }
                &class1("PRO", $transcript, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes PRO-Format. Korrekt wre: (\\d+;\\d+|\\d+)\\s*(SM1|SM2|SM3|SS1|SS2|SC2|SC3|PM1|PM3|PC2|LC2|LS2|RC1|RC2|RS2|EM3|FM3|DS1|DS3|AM2|AM3|AC1|IC0|IC1|IC2)\n",
                "(Ein oder zwei Zahlen, Marker-String)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "LEX") { # Integer, Marker-String aus Integer und Text
            if ($2 =~ /^(\d+)\s*(\d+)\s*(UNKNOWN|ADJA|ADJD|ADV|APPR|APPRART|APPO|APZR|ART|CARD|FM|ITJ|KOUI|KOUS|KON|KOKOM|NN|NE|PDS|PDAT|PIS|PIAT|PIDAT|PPER|PPOSS|PPOSAT|PRELS|PRELAT|PRF|PWS|PWAT|PWAV|PAV|PTKZU|PTKNEG|PTKVZ|PTKANT|PTKA|TRUNC|VVFIN|VVIMP|VVINF|VVIZU|VVPP|VAFIN|VAIMP|VAINF|VAPP|VMFIN|VMINF|VMPP|XY|\$\,|\$\.|\$\(|PROP|BS)$/) {
                $link = $1;
                $index = $2;
                $transcript = $3;
                &class1("LEX", $transcript, $link, $link + 1);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "Syntaxtree-Index");
                $feature->addText("$index");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes LEX-Format. Korrekt wre: \\d+\\s*\\d+\\s*(UNKNOWN|ADJA|ADJD|ADV|APPR|APPRART|APPO|APZR|ART|CARD|FM|ITJ|KOUI|KOUS|KON|KOKOM|NN|NE|PDS|PDAT|PIS|PIAT|PIDAT|PPER|PPOSS|PPOSAT|PRELS|PRELAT|PRF|PWS|PWAT|PWAV|PAV|PTKZU|PTKNEG|PTKVZ|PTKANT|PTKA|TRUNC|VVFIN|VVIMP|VVINF|VVIZU|VVPP|VAFIN|VAIMP|VAINF|VAPP|VMFIN|VMINF|VMPP|XY|\$,|\$.|\$\(|PROP|BS)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "SYN") { # Integer-Liste, Marker-String aus Integer und Kategorie
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(\d+)\s*(--|NX|PX|SIMPX|VXFIN|MF|VC|NF|LK|VF|ADVX|ADJX|P-SIMPX|R-SIMPX|VXINF|DM|MVC|PARORD|C|KOORD|LV|VCN|LKMVC|LKVCN|LKM|MVCN|MN|DP|KONX|VLKM|VLKMVC|LKMVCN|LKMN|FKOORD|LKN|CMVCN)$/) {
                $index = $2;
                $cat = $3;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("SYN", $cat, $start, $end);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "Syntaxtree-Index");
                $feature->addText("$index");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes SYN-Format. Korrekt wre: (\\d+;\\d+|\\d+(,\\d+)*)\\s*\\d+\\s*(--|NX|PX|SIMPX|VXFIN|MF|VC|NF|LK|VF|ADVX|ADJX|P-SIMPX|R-SIMPX|VXINF|DM|MVC|PARORD|C|KOORD|LV|VCN|LKMVC|LKVCN|LKM|MVCN|MN|DP|KONX|VLKM|VLKMVC|LKMVCN|LKMN|FKOORD|LKN|CMVCN)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "FUN") { # s.o.
            if ($2 =~ /^(\d+;\d+|\d+(?:,\d+)*)\s*(\d+)\s*(--|HD|ON|-|OD|MOD|ON-MOD|OA-MOD|OD-MOD|OPP|ONK|OAK|OV|VPT|MOD-MOD|APP|PRED|OA|V-MOD|MODK|V-MODK|OPP-MOD|PRED-MOD|FOPP|OS|OADVP|FOPP-MOD|OADJP|OADVPMOD|OADJPK|FOPPK|OPPK|OADVPK|PREDK|MOD-MODK|OPP-MODK|PREDMODK)$/) {
                $index = $2;
                $label = $3;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("FUN", $label, $start, $end);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "Syntaxtree-Index");
                $feature->addText("$index");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes FUN-Format. Korrekt wre: (\\d+;\\d+|\\d+(,\\d+)*)\\s*\\d+\\s*(--|HD|ON|-|OD|MOD|ON-MOD|OA-MOD|OD-MOD|OPP|ONK|OAK|OV|VPT|MOD-MOD|APP|PRED|OA|V-MOD|MODK|V-MODK|OPP-MOD|PRED-MOD|FOPP|OS|OADVP|FOPP-MOD|OADJP|OADVPMOD|OADJPK|FOPPK|OPPK|OADVPK|PREDK|MOD-MODK|OPP-MODK|PREDMODK)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "POS") { # Integer, non-whitespace
            if ($2 =~ /^(\d+(?:,\d+)*)\s*(\S+)$/) {
                $marker = $2;
                @numbers = split /,/, $1;
                $start = $numbers[0];
                $end = $numbers[-1] + 1;
                &class1("POS", $marker, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes POS-Format. Korrekt wre: \\d+(,\\d+)*\\s*\\S+\n",
                "(Zahl, Wort)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "LMA") { # auch
            if ($2 =~ /^(\d+(?:,\d+)*)\s*(\S+)$/) {
                $marker = $2;
                @numbers = split /,/, $1;
                $start = $numbers[0];
                $end = $numbers[-1] + 1;
                &class1("LMA", $marker, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes LMA-Format. Korrekt wre: \\d+(,\\d+)*\\s*\\S+\n",
                "(Zahl, Wort)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "IPA") { # zwei Integer, Marker-String aus Integer und Text
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+(?:,\d+)*)\s*(.*)$/) {
                $begin = $1;
                $duration = $2;
                $ipa_list = $3;
                $symbol = $4; # Eigentlich auch eine Liste von Symbolen (kann auch leer sein!)
                &class2("IPA", $ipa_list, $begin, ($begin + $duration));
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "Symbol");
                $feature->addText("$symbol");
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes IPA-Format. Korrekt wre: \\d+\\s*\\d+\\s*\\d+(,\\d+)*\\s*.*\n",
                "(Zahl, Zahl, Zahlenliste, SAM-PA-Symbole)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "TRN") { # zwei Integer, Liste, non-ws
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+(?:,\d+)*)\s*(.*)$/) {
                $begin = $1;
                $duration = $2;
                $label = $4; # optional!
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("TRN", $label, $start, $end);
                &class2("TRN", $label, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "equals");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
#                 $feature = $doc->createElement("Feature");
#                 $feature->setAttribute("name", "Beginn");
#                 $feature->addText("$begin");
#                 $annotation->appendChild($feature);
#                 $feature = $doc->createElement("Feature");
#                 $feature->setAttribute("name", "Dauer");
#                 $feature->addText("$duration");
#                 $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes TRN-Format. Korrekt wre: \\d+\\s*\\d+\\s*\\d+(,\\d+)*\\s*.*\n",
                "(Zahl, Zahl, Zahlenliste, optionales Label)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "TRS") { # Liste, Transliteration (mit ws!)
            if ($2 =~ /^(\d+(?:,\d+)*)\s*(\S.*)$/) {
                $trans = $2;
                if ($1 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $1;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("TRS", $trans, $start, $end);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes TRS-Format. Korrekt wre: \\d+(,\\d+)*\\s*.*\n",
                "(Zahlenliste, Transliteration)";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "GES") { # Zwei Integer, Label-String mit 8-9 Spalten
            $string = $2;
            local $error = 0;
            if ($string =~ /^(\d+)/) {
                $begin = $1;
                $string =~ s/^\d+\s*//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der ersten Spalte. Korrekt wre: ",
                "\\d+ (Beginn)";
                goto ERROR;
            }
            if ($string =~ /^(\d+)/) {
                $duration = $1;
                $string =~ s/^\d+\s*//;
                $label = $string;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der zweiten Spalte. Korrekt wre: ",
                "\\d+ (Dauer)";
                goto ERROR;
            }
            if ($string =~ /^([IUR]-Geste)\t/) {
                $grobgeste = $1;
                $string =~ s/^[IUR]-Geste\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der dritten Spalte. Korrekt wre: ",
                "[IUR]-Geste (Grobgeste)";
                goto ERROR;
            }
            if ($string =~ /^(I - deut [+-]|I - tipp [+-]|I - kreis [+-]|I - frei [+-]|U - (?:les|such|z\"ahl|\"uberleg) - k|U - (?:les|\"uberleg) - p|R - emot [+-]|R - UFO|nicht erkennbar)\t/) {
                $feingeste = $1;
                $string =~ s/^(I - deut [+-]|I - tipp [+-]|I - kreis [+-]|I - frei [+-]|U - (les|such|z\"ahl|\"uberleg) - k|U - (les|\"uberleg) - p|R - emot [+-]|R - UFO|nicht erkennbar)\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der vierten Spalte. Korrekt wre: ",
                "I - deut [+-]|I - tipp [+-]|I - kreis [+-]|I - frei [+-]|U - (les|such|z\"ahl|\"uberleg) - k|U - (les|\"uberleg) - p|R - emot [+-]|R - UFO|nicht erkennbar (Feingeste)";
                goto ERROR;
            }
            if ($string =~ /^((?:(?:Zeige|Mittel|Ring|Kleiner|Daumen)?\s*(?:re|li|re \/ li)\s*(?:Hand|Stift|Kopf))?|nicht erkennbar)\t/) {
                $fhs = $1; # Finger, Hand oder Stift. Kopf auch OK?
                $string =~ s/^(((Zeige|Mittel|Ring|Kleiner|Daumen)?\s*(re|li|re \/ li)\s*(Hand|Stift|Kopf))?|nicht erkennbar)\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der fnften Spalte. Korrekt wre: ",
                "((Zeige|Mittel|Ring|Kleiner|Daumen)?\\s*(re|li|re \/ li)\\s*(Hand|Stift|Kopf))?|nicht erkennbar (Finger, Hand oder Stift)";
                goto ERROR;
            }
            if ($string =~ /^([^\t]*)\t/) {
                $refword = $1;
                $string =~ s/^[^\t]*\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der sechsten Spalte. Korrekt wre: ",
                "[^\\t]* (Wort)";
                goto ERROR;
            }
            if ($string =~ /^(|Mitte|links unten|links oben|rechts unten|rechts oben|gesamtes Display|nicht erkennbar)\t/) {
                $place = $1;
                $string =~ s/^(|Mitte|links unten|links oben|rechts unten|rechts oben|gesamtes Display|nicht erkennbar)\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der siebten Spalte. Korrekt wre: ",
                "|Mitte|links unten|links oben|rechts unten|rechts oben|gesamtes Display|nicht erkennbar (Ort)";
                goto ERROR;
            }
            if ($string =~ /^(|Treffer|oberhalb|unterhalb|links|rechts|leer|nicht erkennbar)\t/) {
                $object = $1;
                $string =~ s/^(|Treffer|oberhalb|unterhalb|links|rechts|leer|nicht erkennbar)\t//;
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der achten Spalte. Korrekt wre: ",
                "|Treffer|oberhalb|unterhalb|links|rechts|leer|nicht erkennbar (Objekt)";
                goto ERROR;
            }
            if ($grobgeste eq "I-Geste") {
                if ($string =~ /^(\d+)\s*/) {
                    $start = $1;
                    $string =~ s/^\d+\s*//;
                }
                else {
                    warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der neunten Spalte. Korrekt wre: ",
                    "\\d+ (Strokebeginn)";
    #                print $begin, " | ", $duration, " | ", $grobgeste, " | ", $feingeste, " | ", $fhs, " | ", $refword, " | ", $place, " | ", $object, " | ", "\n";
    #                print $string, "\n";
                    goto ERROR;
                }
                if ($string =~ /^(\d+)\s*/) {
                    $length = $1;
                    $string =~ s/^\d+\s*//;
                }
                else {
                    warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes GES-Format in der zehnten Spalte. Korrekt wre: ",
                    "\\d+ (Strokedauer)";
                    goto ERROR;
                }
            }
            goto NO_ERROR;
            ERROR:
            $error = 1;
            &error($content[$i]);
            NO_ERROR:
            if (!$error) {
                $comment = $string;
                &class2("GES", $label, $begin, ($begin + $duration));
                # Alle in Features umbauen.
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "broad category");
                $feature->addText("$grobgeste");
                $annotation->appendChild($feature);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "gesture label");
                $feature->addText("$feingeste");
                $annotation->appendChild($feature);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "tool");
                $feature->addText("$fhs");
                $annotation->appendChild($feature);
                if ($grobgeste eq "I-Geste") {
                    if ($refword) {
                        $feature = $doc->createElement("Feature");
                        $feature->setAttribute("name", "reference word");
                        $feature->addText("$refword");
                        $annotation->appendChild($feature);
                    }
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "reference object");
                    $feature->addText("$object");
                    $annotation->appendChild($feature);
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "begin stroke");
                    $feature->addText("$start");
                    $annotation->appendChild($feature);
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "duration stroke");
                    $feature->addText("$length");
                    $annotation->appendChild($feature);
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "reference zone");
                    $feature->addText("$place");
                    $annotation->appendChild($feature);
                }
                elsif ($grobgeste eq "U-Geste") {
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "reference zone");
                    $feature->addText("$place");
                    $annotation->appendChild($feature);
                }
                if ($comment) {
                    $feature = $doc->createElement("Feature");
                    $feature->setAttribute("name", "comment");
                    $feature->addText("$comment");
                    $annotation->appendChild($feature);
                }
            }
        }
        elsif ($1 eq "USH") { # Zwei Integer, bis zu zweispaltiger Label-String
            if ($2 =~ /^(\d+)\s*(\d+)\s*(Neutral|(?:Freude\/Erfolg|\"Arger\/Mi\"serfolg|Ratlosigkeit|\"Uberlegen\/Nachdenken|\"Uberraschung\/Verwunderung|Restklasse)\s*(stark|schwach)?)\s*$/) {
                $begin = $1;
                $duration = $2;
                $label = $3;
                $strength = $4;
                &class2("USH", $label, $begin, ($begin + $duration));
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "strength");
                $feature->addText("$strength") if $strength;
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes USH-Format. Korrekt wre: \\d+\\s*\\d+\\s*(Neutral|(Freude/Erfolg|\"Arger/Mi\"serfolg|Ratlosigkeit|\"Uberlegen/Nachdenken|\"Uberraschung/Verwunderung|Restklasse)\\s*(stark|schwach))\n",
                "(Zahl, Zahl, Label, Intensitt [optional])";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "USM") { # too
            if ($2 =~ /^(\d+)\s*(\d+)\s*(Neutral|(?:Freude\/Erfolg|\"Arger\/Mi\"serfolg|Ratlosigkeit|\"Uberlegen\/Nachdenken|\"Uberraschung\/Verwunderung|Restklasse)\s*(stark|schwach)?)\s*$/) {
                $begin = $1;
                $duration = $2;
                $label = $3;
                $strength = $4;
                &class2("USM", $label, $begin, ($begin + $duration));
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "strength");
                $feature->addText("$strength") if $strength;
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes USM-Format. Korrekt wre: \\d+\\s*\\d+\\s*(Neutral|(Freude/Erfolg|\"Arger/Mi\"serfolg|Ratlosigkeit|\"Uberlegen/Nachdenken|\"Uberraschung/Verwunderung|Restklasse)\\s*(stark|schwach))\n",
                "(Zahl, Zahl, Label, Intensitt [optional])";
                &error($content[$i]);
            }
        }
        elsif ($1 eq "OCC") { # Zwei Integer, Label-String mit ws
            if ($2 =~ /^(\d+)\s*(\d+)\s*((?:Hand|Stift|Objekt) im Gesicht(?:|\/Mund|\/Nase|\/Augen)|Teilweise nicht im Bild)\s*$/) {
                $begin = $1;
                $duration = $2;
                $label = $3;
                &class2("OCC", $label, $begin, ($begin + $duration));
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes OCC-Format. Korrekt wre: \\d+\\s*\\d+\\s*((Hand|Stift|Objekt) im Gesicht(|/Mund|/Nase|/Augen)|Teilweise nicht im Bild)\n",
                "(Zahl, Zahl, Label)";
                &error($content[$i]);
            }
        }
        ## Zustzlich auch noch in Samples?
        elsif ($1 eq "USP") { # Zwei Integer, Liste, Label (Klassen)
            if ($2 =~ /^(\d+)\s*(\d+)\s*(\d+;\d+|\d+(?:,\d+)*)\s*(CLEAR_ART|HYPER_ART|EMPHASIS|STRONG_EMPH|LENGTH_SYLL|PAUSE_PHRASE|PAUSE_WORD|PAUSE_SYLL|LAUGHTER)\s*$/) {
                $begin = $1;
                $duration = $2;
                $label = $4;
                if ($3 =~ /^\d+;(\d+)$/) {
                    $start = $end = $1;
                }
                else {
                    @numbers = split /,/, $3;
                    $start = $numbers[0];
                    $end = $numbers[-1] + 1;
                }
                &class1("USP", $label, $start, $end);
                &class2("USP", $transcript, $begin, $begin + $duration);
                $feature = $doc->createElement("Feature");
                $feature->setAttribute("name", "equals");
                $feature->addText("Ann" . ($annotation_id_counter - 2)); # Alte Annotation
                $annotation->appendChild($feature);
            }
            else {
                warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes USP-Format. Korrekt wre: \\d+\\s*\\d+\\s*(\\d+:\\d+|\\d+(,\\d+)*)\\s*(CLEAR_ART|HYPER_ART|EMPHASIS|STRONG_EMPH|LENGTH_SYLL|PAUSE_PHRASE|PAUSE_WORD|PAUSE_SYLL|LAUGHTER)\n",
                "(Zahl, Zahl, Zahlenliste, Label)";
                &error($content[$i]);
            }
        }
# Falls wir irgendwann noch mehr Formate brauchen...
#         elsif ($1 eq "") { #
#             if ($2 =~ /^()\s*()$/) {
#                 ;
#                 $feature = $doc->createElement("Feature");
#                 $feature->setAttribute("name", "");
#                 $feature->addText("\$");
#                 $annotation->appendChild($feature);
#             }
#             else {
#                 warn "Datei $inputname, Zeile ", ($i+1), ": Ungltig geformtes -Format. Korrekt wre: ";
#                 warn "$content[$i]";
#                 $exit_status++;
#             }
#         }
        else {
            warn "Datei $inputname, Zeile ", ($i+1), " passt auf keins der bekannten Formate!";
            &error($content[$i]);
        }
    }
    else {
        warn "Datei $inputname, Zeile ", ($i+1), ": $content[$i] enthlt kein gltiges Label!";
        &error($content[$i]);
    }
    $i++;
}

# AG mit Anchor und Annotation.
$root->appendChild($ag);

$inputname =~ s/par$/ags/;
$doc->printToFile($inputname) or exit(-1) and warn "XML-File konnte nicht erzeugt werden!";
# In lesbares XML umformen
`/homes/smart/bin/xmlind.pl $inputname`;
exit($exit_status) and print "$exit_status\n";

sub class1 { # Einheit: Worte
    my $label = $_[0];
    my $transcript = $_[1];
    my $start = $_[2];
    my $end = $_[3];

    if ($label ne $format) { # Neues Format beginnt
        unless ($timeline) { # Timeline anlegen
            $timeline_id_counter++;
            $timeline = $doc->createElement("Timeline");
            $timeline->setAttribute("id", "T" . $timeline_id_counter);

            $signal = $doc->createElement("Signal");
            $signal->setAttribute("id", "S" . $signal_id_counter);
            $signal_id_counter++;
            $signal->setAttribute("mimeClass", $mime{"mimeClass"});
            $signal->setAttribute("mimeType", $mime{"mimeType"});
            $signal->setAttribute("encoding", $mime{"encoding"});
            $signal->setAttribute("unit", "word");
            $signal->setAttribute("xlink:type", "simple");
            $signal->setAttribute("xlink:href", "$inputname");
#            $signal->setAttribute("track", "");
            $timeline->appendChild($signal);
            $root->appendChild($timeline);
            ;
        }
        if ($ag) { # Letzte AG
            if ($ag_id_counter == 2) { # Nur bei der ersten AG
                # Und am Ende noch einen fr den Abschluss.
                $anchor = $doc->createElement("Anchor");
                $anchor->setAttribute("id", "A" . $anchor_id_counter);
                $anchor->setAttribute("offset", "$anchor_id_counter");
                $anchor_id_counter++;
                $anchor->setAttribute("unit", "word");
#                $anchor->setAttribute("signals", "");
                $ag->insertBefore($anchor, $ann0);
            }
            $root->appendChild($ag);
        }
        $ag = $doc->createElement("AG");
        $ag->setAttribute("id", "t" . $ag_id_counter);
        $ag->setAttribute("type", $formate{$label}[1]); # Ausgeschriebene Form
        $ag->setAttribute("timeline", "T" . $timeline_id_counter);
        $ag_id_counter++;
        $format = $label;
    }
    if ($ag_id_counter == 2) { # Nur bei der ersten AG
        $anchor = $doc->createElement("Anchor");
        $anchor->setAttribute("id", "A" . $anchor_id_counter);
        $anchor->setAttribute("offset", "$anchor_id_counter");
        $anchor_id_counter++;
        $anchor->setAttribute("unit", "word");
#        $anchor->setAttribute("signals", "");
        $ag->insertBefore($anchor, $ann0);
        $first_ag = $ag; # Allererste AG
    }
    $annotation = $doc->createElement("Annotation");
    $annotation->setAttribute("id", "Ann" . $annotation_id_counter);
    $annotation_id_counter++;
    $annotation->setAttribute("type", $format);
    $annotation->setAttribute("start", "A$start");
    $annotation->setAttribute("end", "A$end");
    if ($annotation_id_counter == 1) {
        $ann0 = $annotation;
    }

    $feature = $doc->createElement("Feature");
    $feature->setAttribute("name", $formate{$label}[0]);
    $feature->addText("$transcript");
    $annotation->appendChild($feature);
    $ag->appendChild($annotation);
    ;
}

sub class2 { # Einheit: Samples
    ;
    my $label = $_[0];
    my $transcript = $_[1];
    my $start = $_[2];
    my $end = $_[3];

    if ($label ne $format) { # Neues Format beginnt
        unless ($timeline2) { # Timeline anlegen - hoffentlich stimmt das Format
#            $timeline_id_counter++;
            $timeline2 = $doc->createElement("Timeline");
#            $timeline2->setAttribute("id", "T" . $timeline_id_counter);

            $signal = $doc->createElement("Signal"); ## Signal ntig?
            $signal->setAttribute("id", "S" . $signal_id_counter);
            $signal_id_counter++;
            $signal->setAttribute("mimeClass", $mime{"mimeClass"}); # Oder immer einfacher Text/BAS?
            $signal->setAttribute("mimeType", $mime{"mimeType"});
            $signal->setAttribute("encoding", $mime{"encoding"});
            $signal->setAttribute("unit", "16kHz");
            $signal->setAttribute("xlink:type", "simple");
            $signal->setAttribute("xlink:href", "$inputname");
#            $signal->setAttribute("track", ""); # Optional
#            $timeline->appendChild($signal);
#            $root->insertBefore($timeline2, $first_ag);
            ;
        }
        if ($ag) { # Letzte AG
            $root->appendChild($ag);
        }
        $ag = $doc->createElement("AG");
        $ag->setAttribute("id", "t" . $ag_id_counter);
        $ag->setAttribute("type", $formate{$label}[1]); # Ausgeschriebene Form
        $ag->setAttribute("timeline", "T" . $timeline_id_counter);
        $ag_id_counter++;
#        $ag_id_counter2++;
        $format = $label;
    }
    unless (exists $sample_anchors{"$start"}) {
        $sample_anchors{"$start"} = "A" . $anchor_id_counter;
        $anchor = $doc->createElement("Anchor");
        $anchor->setAttribute("id", "A" . $anchor_id_counter); # Ich knnte auch $number nehmen.
        $anchor->setAttribute("offset", "$start");
        $anchor_id_counter++;
        $anchor->setAttribute("unit", "16kHz");
#        $anchor->setAttribute("signals", ""); # Vorsicht, das knnen auch mehrere sein!
        $first_ag->insertBefore($anchor, $ann0); # Soweit OK, aber sollte ich diese Anchors
        # nicht in eine passende AG auch stellen?
    }
    unless ($start == $end and exists $sample_anchors{"$end"}) {
        $sample_anchors{"$end"} = "A" . $anchor_id_counter;
        $anchor = $doc->createElement("Anchor");
        $anchor->setAttribute("id", "A" . $anchor_id_counter);
        $anchor->setAttribute("offset", "$end");
        $anchor_id_counter++;
        $anchor->setAttribute("unit", "16kHz");
#        $anchor->setAttribute("signals", "");
        $first_ag->insertBefore($anchor, $ann0);
    }
    $annotation = $doc->createElement("Annotation");
    $annotation->setAttribute("id", "Ann" . $annotation_id_counter);
    $annotation_id_counter++;
    $annotation->setAttribute("type", $format);
    $annotation->setAttribute("start", $sample_anchors{"$start"});
    $annotation->setAttribute("end", $sample_anchors{"$end"});
#     if ($annotation_id_counter == 1) {
#         $ann0 = $annotation;
#     }

    $feature = $doc->createElement("Feature");
    $feature->setAttribute("name", $formate{$label}[0]);
    $feature->addText("$transcript");
    $annotation->appendChild($feature);
    $ag->appendChild($annotation);
    ;
}

sub error {
    $line = $_[0];
    warn "$line";
    $exit_status++;
}
