function plot_interactive_scatter(array1, array2, labels)
% function plot_interactive_scatter(array1, array2, labels)
%
% CVS_Version_String = '$Id: plot_interactive_scatter.m,v 1.1 2004/04/15 14:10:36 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

if ( (length(array1) ~= length(array2)) | (length(array1) ~= length(labels) ) ),
	error([ mfilename ': lengths of all three parameters must be equal!']);
end

figure;
hold on;
ht=uicontrol('style','text','position',[1 1 200 10],'tag','textbox');
for i=1:length(array1),
        hs=plot(array1(i),array2(i),'yo');
        set(hs,'UserData',labels{i});
        set(hs,'ButtonDownFcn','set(findobj(''tag'',''textbox''),''string'',get(gcbo,''UserData''))');
end


