function coeff=HTK_SigP_Wave2F0Cep(frame,Fs,F0_lo,F0_hi)
% function coeff=HTK_SigP_Wave2F0Cep(frame,Fs,F0_lo,F0_hi)
%
% CVS_Version_String = '$Id: HTK_SigP_Wave2F0Cep.m,v 1.4 2003/11/04 10:34:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (size(frame,2) ~= 1)
		frame = frame';
	end
	
	
	fftSize = 2^(ceil(log2(length(frame))));

	if (fftSize < 1024),
		fftSize = 1024;
	end
	
	SpecFrame = fft(frame,fftSize);
	

	quefrency_hi = ceil((1/F0_lo) / (1/Fs));
	quefrency_lo = floor((1/F0_hi) / (1/Fs));
	
	if (quefrency_hi >= (length(SpecFrame) / 2))
		error('F0 low border to low; increase fft length');
	end
	
	abs_spec = abs(SpecFrame);
	indizes=find(abs_spec == 0);
	
	
	if (~(isempty(indizes))),
		disp(['[HTK_SigP_Wave2F0Cep]: Warning frame contains ' num2str(length(indizes)) ' with zero spectrum amplitude!']);
		disp(['                       location: ' num2str( (indizes-1)/fftSize ) ]);
		for i=1:length(indizes),
			if (indizes(i) == fftSize/2 + 1),
				abs_spec(indizes(i)) = abs_spec(indizes(i) - 1);
			else
 				if (indizes(i) < fftSize/2 + 1),
					abs_spec(indizes(i)) = abs_spec(indizes(i) + 1);
				else
					abs_spec(indizes(i)) = abs_spec(indizes(i) - 1);
				end
			end
		end
	end
	
	CepFrame = real(ifft(log(abs_spec)));
	
	coeff = CepFrame(quefrency_lo:quefrency_hi);
