function add_on_border = calc_add_on_border(borders_sub, prob_sub,fr_fa_type)
% function add_on_border = calc_add_on_border(borders_sub, prob_sub,fr_fa_type)
%
% CVS_Version_String = '$Id: calc_add_on_border.m,v 1.5 2003/12/05 23:41:04 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



			coeff = polyfit(borders_sub, prob_sub, 2);
			if (fr_fa_type == 'FA')
				polyroots = roots(coeff - [0 0 100]);
			else
				polyroots = roots(coeff);
			end
			
			if ~(isreal(polyroots))
				coeff = polyfit(borders_sub, prob_sub, 1);
				if (fr_fa_type == 'FA')
					polyroots = roots(coeff - [0 100]);
				else
					polyroots = roots(coeff);
				end
			end
			% find nearest root below borders_sub(1)
			smaller_value_indizes = find(polyroots < borders_sub(1));
			if (isempty(smaller_value_indizes))
				epsilon = mean(diff(borders_sub)) / 100;
				add_on_border = borders_sub(1) - epsilon;
			else
				[dummy, indizes] = min( abs( borders_sub(1) - polyroots(smaller_value_indizes) ) );
				add_on_border = polyroots(smaller_value_indizes(indizes));
			end	
			
