function reduced_F_struct_array = decompose_F_struct(F_struct,model_list, varargin)
% function reduced_F_struct_array = decompose_F_struct(F_struct,model_list, varargin)
%
% CVS_Version_String = '$Id: decompose_F_struct.m,v 1.5 2004/04/07 13:52:37 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################




	if ~(nargin == 2) & ~(nargin == 3)
		error('decompose_F_struct: wrong number of input parameters');
	end
	
	if (nargin == 3) & (strcmp(varargin{1},'with rec_info')),
		full_rec_info = 1;
	else
		full_rec_info = 0;
	end
	
	
	if (full_rec_info),
		for spk_index = 1:length(model_list),
			reduced_F_struct_array.data(spk_index).borders = [];
			reduced_F_struct_array.data(spk_index).rec_info = [];
			reduced_F_struct_array.data(spk_index).original_index = [];
		end
		for i = 1:length(F_struct.data.borders)
			
			rec_info = F_struct.data.rec_info(i,:);
			model_info = rec_info(1:4);
			
			spk_index = strmatch(model_info,model_list);
			if (~(isempty(spk_index))),
				reduced_F_struct_array.data(spk_index).borders = [reduced_F_struct_array.data(spk_index).borders F_struct.data.borders(i)];
				reduced_F_struct_array.data(spk_index).rec_info(end+1,:) = rec_info;
				reduced_F_struct_array.data(spk_index).original_index(end+1) = i;
			end
		end
	else
		for spk_index = 1:length(model_list),
			reduced_F_struct_array.data(spk_index).borders = [];
			reduced_F_struct_array.data(spk_index).original_index = [];
		end
		for i = 1:length(F_struct.data.borders)
			
			rec_info = F_struct.data.rec_info(i,:);
			model_info = rec_info(1:4);
			
			spk_index = strmatch(model_info,model_list);			
			if (~(isempty(spk_index))),
				reduced_F_struct_array.data(spk_index).borders = [reduced_F_struct_array.data(spk_index).borders F_struct.data.borders(i)];
				reduced_F_struct_array.data(spk_index).original_index = [reduced_F_struct_array.data(spk_index).original_index i];

			end
		end
	end			
	if (isempty(model_list)),
		reduced_F_struct_array.data = [];
	end	
	reduced_F_struct_array.model_name = F_struct.model_name;
	
