function mlf_struct=mlf2matlab( filename, varargin)
% mlf_struct = mlf2matlab( filename, [full_info_flag = 0] )
%
% mlf_struct is a array with as many entries as there
% are files used in the mlf file <filename>.
%
% Each entry has a record with the following fields:
% - file = name of the label/signal file
% - llh_vector = vector with the log-likelihood values 
%   of each state in the mlf. Length depends on the decoded
%   file.
%
% If full_info_flag is set three more fields are computed:
% - start_vector = vector with starting time of labels/phonemes (unit 10ms)
% - end_time = ending time of the last label/phoneme (unit 10ms)
% - phoneme_vector = label / phoneme vector (translated to short labels)
%
%
% CVS_Version_String = '$Id: mlf2matlab.m,v 1.7 2004/02/10 10:51:28 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	if (nargin == 1)
		full_info = 0;
	else
		full_info = varargin{1};
	end

	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	line_counter = length(line_array);

	file_start_indizes = strmatch('"', line_array);
	file_end_indizes = strmatch('.', line_array);

	if ~(length(file_start_indizes) == length(file_end_indizes))
		error(['mlf2matlab: mlf file ' filename ' is not well formed!']);
	end
	
	llh_block_start=file_start_indizes(1);
	tmp_file = line_array{llh_block_start}(2:(end-1));
	slash_index_array = findstr(filesep,tmp_file);
	start_filename_index = slash_index_array(end-2) + 1;
	end_filename_index = length(tmp_file)-12;
	start_file_type = length(tmp_file)-5;
	end_file_type = length(tmp_file)-4;

	% Teste auf FileFormat: Beginn/Ende/Modell/llh/Wort oder Beginn/Ende/Modell/llh 
	% oder Beginn/Ende/State/state llh/Modell/model llh
	% Test wird an erstem Eintrag durchgefuehrt
	first_file_first_line=line_array{file_start_indizes(1)+1};
	field_borders = findstr(first_file_first_line, ' ');
	if (isempty(field_borders)),
		error(['mlf2matlab: first llh line in first file block of mlf file ' filename ' is not well formed!']);
	end
	if (length(field_borders) == 3)
		field_format = 'short';
	elseif (length(field_borders) == 4),
		field_format = 'long';
	elseif (length(field_borders) == 5),
		field_format = 'detailed state';
	else
		error(['mlf2matlab: wrong format in file ' filename ]);
	end
	
	if (strcmp(field_format,'long'))
	
			if (full_info)
		
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						mlf_struct(file_counter).llh_vector = zeros(1,(llh_block_end - 1 - llh_block_start));
						llh_value_counter = 1;
		
						llh_vector_temp = [];
						start_vector_temp = [];
						phoneme_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							llh_vector_temp(llh_value_counter) = sscanf(line(field_borders(3)+1:field_borders(4)-1),'%f');
							start_vector_temp(llh_value_counter) = uint16(sscanf(line(1:field_borders(1)-1),'%d') / 100000);
							phoneme_vector_temp(llh_value_counter) = translate_modelname(line(field_borders(2)+1:field_borders(3)-1));
							if (llh_line_index == (llh_block_end - 1))
								mlf_struct(file_counter).end_time = uint16(sscanf(line(field_borders(1)+1:field_borders(2)-1),'%d') / 100000);
							end
				
							llh_value_counter = llh_value_counter + 1;
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
						mlf_struct(file_counter).start_vector = uint16(start_vector_temp);
						mlf_struct(file_counter).phoneme_vector = uint8(phoneme_vector_temp);
					end % for file_counter
		
			else
			
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						mlf_struct(file_counter).llh_vector = zeros(1,(llh_block_end - 1 - llh_block_start));
						llh_value_counter = 1;
		
						llh_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							llh_vector_temp(llh_value_counter) =  sscanf(line(field_borders(3)+1:field_borders(4)-1),'%f');
							llh_value_counter = llh_value_counter + 1;
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
					end % for file_counter
			
			
			end
	
	elseif (strcmp(field_format,'short')) % field_format == short
	
			if (full_info)
		
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						mlf_struct(file_counter).llh_vector = zeros(1,(llh_block_end - 1 - llh_block_start));
						llh_value_counter = 1;
		
						llh_vector_temp = [];
						start_vector_temp = [];
						phoneme_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							llh_vector_temp(llh_value_counter) = sscanf(line(field_borders(3)+1:end),'%f');
							start_vector_temp(llh_value_counter) = uint16(sscanf(line(1:field_borders(1)-1),'%d') / 100000);
							phoneme_vector_temp(llh_value_counter) = translate_modelname(line(field_borders(2)+1:field_borders(3)-1));
							if (llh_line_index == (llh_block_end - 1))
								mlf_struct(file_counter).end_time = uint16(sscanf(line(field_borders(1)+1:field_borders(2)-1),'%d') / 100000);
							end
				
							llh_value_counter = llh_value_counter + 1;
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
						mlf_struct(file_counter).start_vector = uint16(start_vector_temp);
						mlf_struct(file_counter).phoneme_vector = uint8(phoneme_vector_temp);
					end % for file_counter
		
			else
			
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						mlf_struct(file_counter).llh_vector = zeros(1,(llh_block_end - 1 - llh_block_start));
						llh_value_counter = 1;
		
						llh_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							llh_vector_temp(llh_value_counter) =  sscanf(line(field_borders(3)+1:end),'%f');
							llh_value_counter = llh_value_counter + 1;
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
					end % for file_counter
			
			
			end
	
	elseif (strcmp(field_format,'detailed state'))
	
			if (full_info)
		
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						llh_value_counter = 1;
		
						llh_vector_temp = [];
						start_vector_temp = [];
						phoneme_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							if ( length(field_borders) == 5 ),
								llh_vector_temp(llh_value_counter) = sscanf(line(field_borders(5)+1:end),'%f');
								start_vector_temp(llh_value_counter) = uint16(sscanf(line(1:field_borders(1)-1),'%d') / 100000);
								phoneme_vector_temp(llh_value_counter) = translate_modelname(line(field_borders(4)+1:field_borders(5)-1));
								mlf_struct(file_counter).end_time = uint16(sscanf(line(field_borders(1)+1:field_borders(2)-1),'%d') / 100000);
					
								llh_value_counter = llh_value_counter + 1;
							end
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
						mlf_struct(file_counter).start_vector = uint16(start_vector_temp);
						mlf_struct(file_counter).phoneme_vector = uint8(phoneme_vector_temp);
					end % for file_counter
		
			else
			
					for file_counter = 1:(length(file_start_indizes)),
						llh_block_start=file_start_indizes(file_counter);
						llh_block_end=file_end_indizes(file_counter);
				
						tmp_file = line_array{llh_block_start}(2:(end-1));
						
						mlf_struct(file_counter).file = [tmp_file(start_filename_index:end_filename_index) tmp_file(start_file_type:end_file_type)];
						
						llh_value_counter = 1;
		
						llh_vector_temp = [];
		
						for llh_line_index = llh_block_start+1:llh_block_end-1,
							line = line_array{llh_line_index};
							field_borders = findstr(line, ' ');
							if (isempty(field_borders)),
								error(['mlf2matlab: llh file block starting at line ' llh_block_start ' in file ' filename ' is not well formed!']);
							end
							if ( length(field_borders) == 5 ),
								llh_vector_temp(llh_value_counter) =  sscanf(line(field_borders(5)+1:end),'%f');
								llh_value_counter = llh_value_counter + 1;
							end
						end
						mlf_struct(file_counter).llh_vector = single(llh_vector_temp);
					end % for file_counter
			
			
			end
	
	
	end
	
	

