function mmf_struct=mmf2matlab( filename)
% mmf_struct = mmf2matlab( filename)
%
% CVS_Version_String = '$Id: mmf2matlab.m,v 1.4 2003/12/10 20:00:46 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################



	covkind_cell = {'DIAGC','INVDIAGC','FULLC','LLTC','XFORMC'};
	durkind_cell = {'NULLD','POISSOND','GAMMAD','GEND'};
	parm_kind_base_cell = {'DISCRETE','LPC','LPCEPSTRA','MFCC','FBANK','MELSPEC','LPREFC','LPDELCEP','USER'};
	
	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	total_lines = length(line_array);

	mmf_struct.state=[];
	
	state_counter = 0;
	mix_counter = 0;
	
	for line = 1:total_lines,

		tmp_line = line_array{line};
		
		if (findstr('<VECSIZE>', tmp_line)),
			open_par = findstr('<',tmp_line);
			close_par = findstr('>',tmp_line);
			mmf_struct.vector_size = sscanf(tmp_line(close_par(1)+1:open_par(2)-1), '%d');
			for i=2:length(open_par)
				keyword = tmp_line(open_par(i) + 1:close_par(i)-1);
				if(findstr_inCell(keyword,covkind_cell)),
					mmf_struct.covKind = keyword;
				end
				if(findstr_inCell(keyword,durkind_cell)),
					mmf_struct.durKind = keyword;
				end
				if(findstr_inCell(keyword,parm_kind_base_cell)),
					mmf_struct.vector_type = keyword;
				end
			end
		end
		
		if (findstr('<NUMSTATES>',tmp_line)),
			mmf_struct.num_of_states = sscanf(tmp_line(length('<NUMSTATES>')+1:end),'%d');
		end
		
		if (findstr('<STATE>',tmp_line)),
			state_counter = state_counter + 1;
			mix_counter = 0;
			mmf_struct.state(state_counter).mix_number = 1;
			mmf_struct.state(state_counter).state_number = sscanf(tmp_line(length('<STATE>')+1:end),'%d');
		end

		if (findstr('<NUMMIXES>',tmp_line)),
			mmf_struct.state(state_counter).mix_number = sscanf(tmp_line(length('<NUMMIXES>')+1:end),'%d');
			for m_counter=1:mmf_struct.state(state_counter).mix_number,
				mmf_struct.state(state_counter).mix_weight(m_counter) = 0;
			end
		end

		
		if (findstr('<MIXTURE>',tmp_line)),
			temp= sscanf(tmp_line(length('<MIXTURE>')+1:end),'%d%f');
			mix_counter = temp(1);
			mmf_struct.state(state_counter).mix_weight(mix_counter) = temp(2);
		end

		if (findstr('<MEAN>',tmp_line)),
			line = line+1;
			tmp_line_next = line_array{line};
			if (mix_counter == 0)
				mix_counter = 1;
			end
			mmf_struct.state(state_counter).mean_vector(mix_counter,:) = sscanf(tmp_line_next,'%f');
		end

		if (findstr('<VARIANCE>',tmp_line)),
			line = line+1;
			tmp_line_next = line_array{line};
			mmf_struct.state(state_counter).variance_vector(mix_counter,:) = sscanf(tmp_line_next,'%f');
		end
		if (findstr('<INVCOVAR>',tmp_line)),
			N = sscanf(tmp_line(length('<INVCOVAR>')+1:end),'%d');
			for i=1:N,
				line = line+1;
				tmp_line_next = line_array{line};
				mmf_struct.state(state_counter).invcovar(mix_counter,i,:) = [ zeros(i-1,1); sscanf(tmp_line_next,'%f')   ]';
			end
		end

		if (findstr('<GCONST>',tmp_line)),
			mmf_struct.state(state_counter).gconst(mix_counter,:) = sscanf(tmp_line(length('<GCONST>')+1:end),'%f');
		end

		if (findstr('<TRANSP>',tmp_line)),
			mmf_struct.A_size = sscanf(tmp_line(length('<TRANSP>')+1:end),'%d');
			for i = 1:mmf_struct.A_size,
				line = line+1;
				tmp_line_next = line_array{line};
				tmp_vector = sscanf(tmp_line_next,'%f');
				mmf_struct.A(i,:) = tmp_vector;
			end
			
		end
		
		
		
	end % for line ...

	for i=1:length(mmf_struct.state),
		if (~(isfield(mmf_struct.state(i),'mix_weight'))),
			mmf_struct.state(i).mix_weight(1) = 1;
		end
	end
	
	for state_counter=1:length(mmf_struct.state),
	
		for m_counter=1:mmf_struct.state(state_counter).mix_number
			if (mmf_struct.state(state_counter).mix_weight(m_counter) == 0),
				mmf_struct.state(state_counter).mean_vector(m_counter,:) = zeros(size(mmf_struct.state(state_counter).mean_vector(1,:)));
				mmf_struct.state(state_counter).variance_vector(m_counter,:) = zeros(size(mmf_struct.state(state_counter).variance_vector(1,:)));
				mmf_struct.state(state_counter).gconst(m_counter,:) = zeros(size(mmf_struct.state(state_counter).gconst(1,:)));
			end
		end
	end
	
