function  spk_struct_array = read_spk_info
% function  spk_struct_array = read_spk_info
%
% CVS_Version_String = '$Id: read_spk_info.m,v 1.7 2004/02/05 11:14:05 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	
	SR_lib;
	
	spk_info_file = 'SPEAKER.TBL';
	
	
	filename = [doc_path spk_info_file];
	
	line_array=textread(filename,'%s','delimiter','\n','whitespace','');

	line_counter = length(line_array);
	
	for current_line_index = 2:line_counter,
		current_line = line_array{current_line_index};
		tab_indizes = findstr(current_line,'	');
		spk_id = current_line(1:tab_indizes(1) - 1);
		sex = current_line(tab_indizes(1) + 1:tab_indizes(2) - 1);
		age = current_line(tab_indizes(2) + 1:tab_indizes(3) - 1);
		region = current_line(tab_indizes(3) + 1:end);
		%disp(['Speaker ' spk_id ', sex ' sex ', age ' age ', region ' region]);
		spk_number = str2num(spk_id);
		spk_struct_array(spk_number) = struct('sex', sex, 'age', age, 'region', region);
	end
