function wave_out = wave_cut_const_levels(wave_in, min_length, cut_length)
% function wave_out = wave_cut_const_levels(wave_in, min_length, cut_length)
%
% CVS_Version_String = '$Id: wave_cut_const_levels.m,v 1.1 2004/04/28 15:16:30 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################

constPart_starts=[];
constPart_ends=[];
level_counter = 0;

flip_size = 0;

if (size(wave_in,1) > size(wave_in,2)),
	wave_in = wave_in';
	flip_size = 1;
end

prev_value = wave_in(1) - 1;

for i=1:length(wave_in),
	current_value = wave_in(i);
	if (current_value == prev_value),
		level_counter = level_counter + 1;
	else
		if (level_counter >= min_length),
			constPart_starts(end+1) = i - level_counter;
			constPart_ends(end+1) = i;
			level_counter = 0;
		end
	end
	prev_value = current_value;
end

constPart_starts;
constPart_ends;


if (length(constPart_starts) > 0),
	
	if (constPart_starts(1) ~=1 ),
		wave_out = wave_in(1:constPart_starts(1)-1);
	end
	
	if (length(constPart_starts) > 1),
		for part=1:(length(constPart_starts) - 1),
			wave_out = [ wave_out   wave_in(constPart_starts(part):cut_length) ];
			wave_out = [ wave_out   wave_in(constPart_ends(part):(constPart_starts(part+1)-1)) ];
		end
	end
	wave_out = [ wave_out   wave_in(constPart_starts(end):cut_length) ];
	wave_out = [ wave_out   wave_in(constPart_ends(end):end) ];

else
	wave_out = wave_in;
end

if (flip_size),
	wave_out = wave_out';
end
