% SR_lib.m
% Set global path variables for both OS architectures (OS X, Linux):
%   rawdatapath
%   basepath
%   scriptpath
%
% Loads session_lists, training_sessions_lists and evaluate_sessions_lists
% using function load_SR_lib_pm_sets
%
% CVS_Version_String = '$Id: SR_lib.m,v 1.17 2004/02/16 10:11:14 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################




platform_used = computer;

global basepath scriptpath;
global sessions_lists;
global sets;


	env_struct = {'MASV_SOURCE_DATABASE'; 'MASV_PARAMPOOL_DIR'; 'MASV_BASEDIR'; 'MASV_MATLAB_RESULTSDIR'; 'MASV_PERL_ROOT'; 'MASV_DATABASE_DESCRIPTION'};
	for i=1:length(env_struct),
		if (length(getenv(env_struct{i})) == 0),
			error(['Environment variable ' env_struct{i} ' not set! Fix this in your .profile or .bashrc/.tcshrc etc.']);
		end
	end
	
	rawdatapath = getenv('MASV_SOURCE_DATABASE'); % '/raid/tera6/VERIDAT/VD/';
	poolpath = getenv('MASV_PARAMPOOL_DIR'); %'/raid/tera6/VERIDAT/paramPool/';
	basepath = [ getenv('MASV_BASEDIR') 'sv_systems/']; %'/homes/tuerk/Diss/HTK/sv_systems/';
	results_archive = getenv('MASV_MATLAB_RESULTSDIR'); %'/raid/tera6/VERIDAT/sv_systems/results/';
	scriptpath = getenv('MASV_PERL_ROOT'); %'/homes/tuerk/Scripts/';
	doc_path = getenv('MASV_DATABASE_DESCRIPTION'); %'/homes/tuerk/Diss/HTK/database_desc/veridat_raw/';
	
addpath(doc_path);

[sessions_lists] = load_SR_lib_pm_sets;
[sampling_freq, audio_type, audio_file_ext, label_file_ext] = read_database_description;

