function score_result_struct=calc_score_result(result_struct, varargin)
% function score_result_struct=calc_score_result(result_struct, [result_type, description, menu_descr, threshold, 
% include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions])
% see add_part_to_score_result for description of optional parameters
% default values are
%		result_type = 'eer';
%		description = 'Standard eer part, same gender impostors';
%		menu_descr = 'SD, a post. th @ EER';
%		threshold = 0; % dummy value
% 		include_models = result_struct.model_info.trained_models;
%		imp_spks_list = {'same gender'};
%		fr_sel_sessions = {'without training'};
%		fa_sel_sessions = {'all'};
%
%
%
% CVS_Version_String = '$Id: calc_score_result.m,v 1.13 2004/05/06 13:39:40 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


	SR_lib;

	
	
	score_result_struct=struct('exp_name','','result_name','');
	
	score_result_struct.exp_name = result_struct.exp_name;
	score_result_struct.result_name = result_struct.result_name;
	score_result_struct.full_name = result_struct.full_name;
	if isfield(result_struct, 'info'),
		score_result_struct.info = result_struct.info;
	end
	score_result_struct.part = {};
	
	score_result_struct.model_info = result_struct.model_info;

	if (nargin == 9)
		% take arguments from call
		result_type = varargin{1};
		description = varargin{2};
		menu_descr = varargin{3};
		threshold = varargin{4};
		include_models = varargin{5};
		imp_spks_list = varargin{6};
		fr_sel_sessions = varargin{7};
		fa_sel_sessions = varargin{8};
	else
		include_models = result_struct.model_info.trained_models;

		imp_spks_list = {'same gender'};

		% erster part mit eer:
		fr_sel_sessions = {'without training'};
		fa_sel_sessions = {'all'};
		menu_descr = 'SD, a post. th @ EER';
		description = 'Standard eer part, same gender impostors';
		result_type = 'eer';
		threshold = 0; % dummy value
	end
	
	score_result_struct = add_part_to_score_result(result_struct, score_result_struct, result_type, description, menu_descr, threshold, include_models, imp_spks_list, fr_sel_sessions, fa_sel_sessions);
