function create_SD_info(pool_name, file_pattern_cell)
% function create_SD_info(pool_name, file_pattern_cell)
% 
% CVS_Version_String = '$Id: create_SD_info.m,v 1.7 2004/04/30 14:44:33 tuerk Exp $';
% CVS_Name_String = '$Name: rel-1-4-01 $';

% ###########################################################
%
% This file is part of the matlab scripts of the MASV System.
% MASV = Munich Automatic Speaker Verification
%
% Copyright 2002-2003, Ulrich Trk
% Institute of Phonetics and Speech Communication
% University of Munich
% tuerk@phonetik.uni-muenchen.de
%
%
%   MASV is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   MASV is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with MASV; if not, write to the Free Software
%   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
%
% ###########################################################


SR_lib;

if ( ~iscell(file_pattern_cell) & (length(file_pattern_cell) == 1) ),
	file_pattern_cell={ file_pattern_cell };
end
for i=1:length(file_pattern_cell),
	file_pattern_cell{i} = [ '*' file_pattern_cell{i} '.' audio_file_ext];
end



pool_dir = [poolpath pool_name filesep];
info_dir = [pool_dir 'SD_info' filesep];

unix([ 'rm -rf ' info_dir ]);

status=mkdir(pool_dir, 'SD_info'); 
cd(pool_dir);



configFullPath = [pool_dir 'configs' filesep 'C_' pool_name];

pool_config = read_paramPool_config(configFullPath);

% all spks
ds=dir([pool_dir '0*']);
for i=1:length(ds),
	spk_list{i} =  ds(i).name;
end
spk_list=sort(spk_list);

% all sessions
sessions_list = {sessions_lists{1}.item{:} sessions_lists{2}.item{:} sessions_lists{3}.item{:} sessions_lists{4}.item{:}};

for current_spk=1:length(spk_list),
	status=mkdir( info_dir, spk_list{current_spk} );
	cd(spk_list{current_spk});
	disp(['Current speaker: ' spk_list{current_spk}]);
		for current_session = 1:length(sessions_list),
			current_info_dir = [ info_dir spk_list{current_spk} filesep sessions_list{current_session} filesep ];
			status=mkdir( [ info_dir spk_list{current_spk} ], sessions_list{current_session});
			cd(sessions_list{current_session});
			disp(['  Current session: ' sessions_list{current_session}]);
			dirstruct = dir_with_pattern_cell( fullfile(rawdatapath, spk_list{current_spk}, sessions_list{current_session}), file_pattern_cell );
			for filecounter = 1:length(dirstruct),
				rawfilename = [rawdatapath spk_list{current_spk} '/' sessions_list{current_session} '/' dirstruct(filecounter).name];
				disp(['    Current recording: ' dirstruct(filecounter).name(1:8)]);
				rawwave = read_raw_alaw(rawfilename);
				rawwave = rawwave * 4096;
				[rawwave_SD, border_info] = HTK_SigP_SilenceDetection( rawwave, pool_config);
				info_filename=[ current_info_dir dirstruct(filecounter).name(1:8) '.SD_info'];
				info_cell{1}=['spDetStart_samples: ' num2str(border_info.spDetStart_samples)];
				info_cell{2}=['spDetEnd_samples: ' num2str(border_info.spDetEnd_samples)];
				result=textwrite(info_filename, info_cell, 'w');
			end
			clear HTK_SigP_SilenceDetection;
			cd ..
		end
		
	cd ..

end



