function [d,fp,dt,tc,t,magic]=readhtk(file)
%READHTK  read an HTK parameter file [D,FP,DT,TC,T,MAGIC]=(FILE)
%
% d is data, fp is frame period in seconds
% dt is data type, tc is full type code, t is a text version of the full typecode,
% magic is the magic number (used by VQ tables).
% tc is the sum of the following values:
%			0		WAVEFORM
%			1		LPC
%			2		LPREFC
%			3		LPCEPSTRA
%			4		LPDELCEP
%			5		IREFC
%			6		MFCC
%			7		FBANK
%			8		MELSPEC
%			9		USER
%			10		DISCRETE
%			64		-E		Includes energy terms
%			128	_N		Suppress absolute energy
%			256	_D		Include delta coefs
%			512	_A		Include acceleration coefs
%			1024	_C		Compressed (not implemented yet)
%			2048	_Z		Zero mean static coefs
%			4096	_K		CRC checksum (not implemented yet)
%			8192	_0		Include 0'th cepstral coef


%      Copyright (C) Mike Brookes 1997
%
%      Last modified Tue May 12 16:13:33 1998
%
%   VOICEBOX home page: http://www.ee.ic.ac.uk/hp/staff/dmb/voicebox/voicebox.html
%
%   Modified version, by Ulrich Trk, 2004.
%   - reads now discrete data
%   - computes magic number
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You can obtain a copy of the GNU General Public License from
%   ftp://prep.ai.mit.edu/pub/gnu/COPYING-2.0 or by writing to
%   Free Software Foundation, Inc.,675 Mass Ave, Cambridge, MA 02139, USA.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen(file,'r','b');
if fid < 0
   error(sprintf('Cannot read from file %s',file));
end
nf=fread(fid,1,'long');
fp=fread(fid,1,'long')*1.E-7;
by=fread(fid,1,'short');
tc=fread(fid,1,'short');
hb=floor(tc*pow2(-14:-6));
hd=hb(9:-1:2)-2*hb(8:-1:1);

dt=tc-64*hb(9);

% hd(7)=1 CRC check
% hd(5)=1 compressed data

if ( dt == 0 ),
  d=fread(fid,Inf,'short');
elseif ( dt == 10 ),
  d=fread(fid,[by/2,nf],'short').';
else,
  d=fread(fid,[by/4,nf],'float').';
end;
fclose(fid);
if nargout > 2
   hd(7)=0;
   hd(5)=0;
   ns=sum(hd);
   magic = (64 * sum(hd(end:-1:1).*pow2(7:-1:0)) ) + dt;
   kinds=['WAVEFORM  ';'LPC       ';'LPREFC    ';'LPCEPSTRA ';'LPDELCEP  ';'IREFC     ';'MFCC      ';'FBANK     ';'MELSPEC   ';'USER      ';'DISCRETE  ';'???       '];
   kind=kinds(min(dt+1,12),:);
   cc='ENDACZK0';
   t=[kind(1:min(find(kind==' '))-1) reshape(['_'*ones(1,ns);cc(hd>0)],1,2*ns)];
end
