#!/usr/bin/perl

# #####################################################
#
# This file is part of the Perl scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

my $CVS_Version_String = '$Id: calc_GMM_world_llh.pl,v 1.7 2004/02/17 09:43:08 tuerk Exp $';
my $CVS_Name_String = '$Name: rel-1-4-01 $';


use strict;
my ($help, $Identify, $mlf_file, $mlf_handle, @mlf_file_content, $start, $end, $llh,
	$sum_llh, $llh_per_frame, $sum_duration, $frame_duration);

use lib $ENV{"MASV_PERL_ROOT"};

use SR_lib;

use Getopt::Long qw( GetOptions );
use Pod::Usage;

$help = 0;
$Identify = 0;
$frame_duration = 100000;

GetOptions('fd|frame_duration=i' => \$frame_duration, 
           'help|?' => \$help,
           'version' => \$Identify);

if ($Identify) {
	printf "$0\n$CVS_Version_String\n$CVS_Name_String\n\n"; 
}

if ((@ARGV != 1) || ($help)) {
   pod2usage(1);
   exit 1;
 }
 

$mlf_file = $ARGV[0];

# File lesen
$mlf_handle = &SR_lib::open_file("<", "$mlf_file");
@mlf_file_content = <$mlf_handle>;
close $mlf_handle;
	

$sum_duration = 0;
$sum_llh = 0;
foreach my $line (@mlf_file_content) {
	if ($line =~ /^\d+\s+\d+/) {
		my @line_contents = split( /\s/, $line);
		$start = int($line_contents[0] / $frame_duration + 0.5);
		$end = int($line_contents[1] / $frame_duration + 0.5);
		$sum_duration += ($end - $start + 1);
		$sum_llh += $line_contents[3];
	}
}

$llh_per_frame = $sum_llh / $sum_duration;

print STDOUT "$llh_per_frame\n";

exit 0;


__END__

=head1 NAME

calc_GMM_world_llh.pl  - Calculate the llh per frame over all entries 
                            in a MLF file.

=head1 SYNOPSIS

calc_GMM_world_llh.pl  mlf_file

This tool is useful to determine how good a GMM model fits to speech data. 
It is usually only used by "run_worldModelTest.pl".

 Options:

 - fd|frame_duration = i       duration of a frame, given in HTK's 100ns units;
                               default is 100000 (= 10ms ).
=cut

