#!/bin/bash

# #####################################################
#
# This file is part of the Bash scripts of the MASV System.
# MASV = Munich Automatic Speaker Verification
#
# Copyright 2002-2003, Ulrich Trk
# Institute of Phonetics and Speech Communication
# University of Munich
# tuerk@phonetik.uni-muenchen.de
#
#
#   MASV is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   MASV is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with MASV; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# #####################################################

# '$Id: create_difference_list.sh,v 1.4 2003/11/03 16:57:52 tuerk Exp $';
# '$Name: rel-1-4-01 $';

if test $# -ne 3 ; then
{
	echo Usage:
	echo
	echo create_difference_list.sh  complete_list  subset  difference_subset
	echo
	echo "Creates a difference list (all entries from <complete list> not" 
	echo "contained in <subset>."
	echo
	exit 1
}
fi

complete_file=$1
subset1_file=$2
subset2_file=$3

sort $complete_file > complete_file_for_create_difference_lists
sort $subset1_file > subset1_file_for_create_difference_lists

comm -3 complete_file_for_create_difference_lists subset1_file_for_create_difference_lists > $subset2_file

rm complete_file_for_create_difference_lists
rm subset1_file_for_create_difference_lists

