import {BrowserModule} from '@angular/platform-browser';
import {ModuleWithProviders, NgModule} from '@angular/core';

import {AppComponent} from './app.component';
import {
  ApiType, RecordingFileService, RecordingFileUI, RecordingFileViewComponent,
  ScriptService,
  SPEECHRECORDER_CONFIG,
  SpeechRecorderConfig,
  SpeechrecorderngComponent,
  SpeechrecorderngModule,
  AudioRecorder
} from 'speechrecorderng'
import {RouterModule, Routes} from '@angular/router';
import {BrowserAnimationsModule} from "@angular/platform-browser/animations";
import { MatButtonModule } from "@angular/material/button";
import { MatDialogModule } from "@angular/material/dialog";
import { MatIconModule } from "@angular/material/icon";
import { MatMenuModule } from "@angular/material/menu";
import { MatToolbarModule } from "@angular/material/toolbar";
import { HTTP_INTERCEPTORS } from '@angular/common/http';
import {CSRFProtectInterceptor} from "./csrf_protect_interceptor";
import {ScriptEditor} from "./script/ScriptEditor";

import {environment} from "../environments/environment";



const WIKISPEECH_ROUTES: Routes = [
    { path: 'db/script/:id', component: ScriptEditor},
  {path: 'db/recordingfile/_view/:recordingFileId', component : RecordingFileViewComponent},
  {path: 'db/recordingfile/_edit/:recordingFileId', component : RecordingFileUI},
  {path: 'db/recordingfile/_view', component : RecordingFileViewComponent},
  {path: 'db/recordingfile/_edit', component : RecordingFileUI},
  {path: 'db/recordingfile/:recordingFileId', component : RecordingFileUI},
  {path: 'db/recordingfile', component : RecordingFileUI},
  {path : 'recorder',component:AudioRecorder},
  { path: '**', component: SpeechrecorderngComponent}
];


 const SPR_CFG:SpeechRecorderConfig={
   apiEndPoint: environment.apiEndPoint,
   apiType: (environment.apiType==='files')?ApiType.FILES:ApiType.NORMAL,
   apiVersion:environment.apiVersion,
   withCredentials:true
 }

// export const SPR_CFG: SpeechRecorderConfig = {
//    apiEndPoint: 'test',
//    apiType: ApiType.FILES,
//    enableDownloadRecordings: true,
//    enableUploadRecordings: false
// };

@NgModule({
  declarations: [
    AppComponent,ScriptEditor
  ],
  imports: [
    RouterModule.forRoot(WIKISPEECH_ROUTES),BrowserModule,BrowserAnimationsModule,SpeechrecorderngModule.forRoot(SPR_CFG),MatToolbarModule,MatMenuModule,MatIconModule,MatButtonModule,MatDialogModule
  ],
  providers: [{
    provide: HTTP_INTERCEPTORS,
    useClass: CSRFProtectInterceptor,
    multi: true,
  },ScriptService,RecordingFileService],
  bootstrap: [AppComponent]
})
export class AppModule {
  static forRoot(): ModuleWithProviders<AppModule> {
    return {
      ngModule: AppModule,
      providers: [
        {provide:  SPEECHRECORDER_CONFIG, useValue: SPR_CFG}
      ]
    };
  }

}
