import { Component } from '@angular/core';
import {RecorderComponent,SpeechrecorderngComponent, VERSION} from 'speechrecorderng';
import {ActivatedRoute, Router} from '@angular/router';
import {ResponsiveComponent} from "speechrecorderng";
import {BreakpointObserver} from "@angular/cdk/layout";

@Component({
    selector: 'app-root',
    templateUrl: './app.component.html',
    styleUrls: ['./app.component.css'],
    standalone: false
})
export class AppComponent extends ResponsiveComponent{
  sprVersion=VERSION;
  title = 'WikiSpeech';
  speechRecorderComp:RecorderComponent;

  constructor(protected bpo:BreakpointObserver){
    super(bpo);
    console.info("Starting WebSpeechrecorderNg "+this.sprVersion);
  }

  onActivate(component){
    if(component instanceof  RecorderComponent){
      this.speechRecorderComp=component;
    }
  }
  onDeactivate(component){
    if(component instanceof  RecorderComponent){
      this.speechRecorderComp=null;
    }
  }

  ready():boolean {
    let ready=true;
    if(this.speechRecorderComp){
      ready=this.speechRecorderComp.ready();
    }
    return ready;
  }
}
