package ips.audio.ds;

import java.util.Iterator;
import java.util.Vector;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

/**
 * The DS implementation for a data line
 * 
 * @author Klaus Jaensch, klausj@phonetik.uni-muenchen.de
 */

public abstract class DSDataLine implements DataLine{

	private static final boolean DEBUG = false;
	
	//protected boolean nativeStopped = false;
	public byte[] nativeDl=null;
	/**
	 * contains info about the type of the line
	 */
	protected DataLine.Info info;

	protected AudioFormat audioFormat;
	//protected int frameSizeInBytes;
	//protected float frameRate;
	
	/**
	 * controls of this line (none implemented) 
	 */
	private Control[] controls = new Control[0];
	/**
	 * true if line is open
	 */
	private boolean open = false;
	
	private Vector<LineListener> listeners;
	//Object bufLock = new Object();
	protected DSMixer mixer;
	//protected byte[] guid;


	protected DSDataLine(
		DSMixer m) {
		this.mixer = m;
		listeners = new Vector<LineListener>();
	}

	public native boolean isRunning();
	public native boolean isActive();
//	protected native void nDrain();
	protected native int nGetFramePosition();

	/* Line interface */

	public void addLineListener(LineListener listener) {
		synchronized(listeners){
		if (listener != null && !listeners.contains(listener)) {
			listeners.addElement(listener);
		}
		}
	}
	public void close() {
		open = false;
		update(new LineEvent(this, LineEvent.Type.CLOSE, getLongFramePosition()));

	}
	

	public Control getControl(Control.Type control) {
		return null;
	}
	public Control[] getControls() {
		return controls;
	}
	public Line.Info getLineInfo() {
		return info;
	}
	public void setLineInfo(DataLine.Info info){
		this.info=info;
	}
	
	public boolean isControlSupported(Control.Type control) {
		return false;
	}
	public boolean isOpen() {
		return open;
	}
	
	public void open() {
		if (open)
			return;
		open = true;
		update(new LineEvent(this, LineEvent.Type.OPEN, 0));
	}
	

	public void removeLineListener(LineListener listener) {
		synchronized(listeners){
		if (listener != null) {
			listeners.removeElement(listener);
		}
		}
	}
	
	public native void nDrain();
	
	public native int getBufferSize();
	public static native int getMaxBufferSize();
	public static native int getMinBufferSize();

	public AudioFormat getFormat() {
		return audioFormat;
	}
	public int getFramePosition(){
		return (int)getLongFramePosition();
	}

	public float getLevel() {
		return -1;
	}

	public long getMicrosecondPosition() {

		long framePos=getLongFramePosition();
		double sPos = ((double) framePos * 1000000);
		double msPos = sPos / audioFormat.getFrameRate();
		if (DEBUG)
			System.out.println(
				framePos + " " + audioFormat.getFrameRate() + " " + sPos + " " + msPos);

		return (long) msPos;
	}
	

	public void start() {
		update(new LineEvent(this, LineEvent.Type.START, getLongFramePosition()));
	}

	public void stop() {
		update(new LineEvent(this, LineEvent.Type.STOP, getLongFramePosition()));
		
	}
	

	/**
	 * sets this line synchronized if isSynced is true,unsynchronized otherwise 
	 * use {@link javax.sound.sampled.Mixer#synchronize(Line[],boolean)}
	 * @param isSynced
	 * @see javax.sound.sampled.Mixer#synchronize(Line[],boolean)
	 * @see javax.sound.sampled.Mixer#unsynchronize(Line[])
	 */
	public void setSynchronized(boolean isSynced) {
		
	}

	protected void update(LineEvent le) {
		synchronized(listeners){
			for(LineListener ll:listeners){
				ll.update(le);
			}
		}
	}


//	/* (non-Javadoc)
//	 * @see javax.sound.sampled.DataLine#getLongFramePosition()
//	 */
//	public long getLongFramePosition() {
//		// TODO !!
//		//return getFramePosition();
//		return 0;
//	}



}
