//    IPS Java Audio Tools
// 	  (c) Copyright 2015
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Audio Tools
//
//
//    IPS Java Audio Tools is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Audio Tools is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Audio Tools.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.audio.dsp.speech.vad;

import ips.dsp.SampledTime;

import java.util.EventObject;

/**
 * @author klausj
 *
 */
public class VoiceActivityDetectorEvent extends EventObject {

	private static final long serialVersionUID = -6902269939368575640L;
	private boolean voiced;
	private SampledTime sampledTimePosition;
	
	/**
	 * @param source source object
	 */
	public VoiceActivityDetectorEvent(Object source) {
		super(source);
		
	}

	/**
	 * @param source source object
	 * @param voiced voice detected
	 * @param sampledTimePosition at sample time position
	 */
	public VoiceActivityDetectorEvent(Object source, boolean voiced,SampledTime sampledTimePosition) {
		super(source);
		this.voiced = voiced;
		this.sampledTimePosition=sampledTimePosition;
	}

	/**
	 * @return is voiced
	 */
	public boolean isVoiced() {
		return voiced;
	}

    public SampledTime getSampledTimePosition() {
        return sampledTimePosition;
    }

}
