package ipsk.net;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import ipsk.text.ParserException;

public class MIMETypeTest {

	@Test
	public void testParse() {
		MIMEType tmt;
		try {
			tmt = MIMEType.parse("audio/wav");
			if(tmt!=MIMEType.AUDIO_WAVE) {
				fail("Failed parsing audio/wav MIME type.");
			}
		} catch (ParserException e) {
			fail("Failed parsing audio/wav MIME type. Exception occured.");
		}
		try {
			tmt = MIMEType.parse("video/webm");
			if(tmt!=MIMEType.VIDEO_WEBM) {
				fail("Failed parsing video/webm MIME type.");
			}
			List<String> tmtPrms=tmt.getParameters();
			if(tmtPrms==null && tmtPrms.size()>0) {
				fail("Failed parsing video/webm MIME type: Parameters parsed wrong.");
			}
		} catch (ParserException e) {
			fail("Failed parsing video/webm MIME type. Exception occured.");
		}
		
		try {
			tmt = MIMEType.parse("video/webm; codec=vp9");
			assertEquals("video", tmt.getType());
			assertEquals("webm", tmt.getSubType());
			assertEquals("webm", tmt.getFileExtension());
			List<String> tmtPrms=tmt.getParameters();
			assertNotNull(tmtPrms);
			assertEquals(1, tmtPrms.size());
			assertEquals("codec=vp9", tmtPrms.get(0));
		} catch (ParserException e) {
			fail("Failed parsing video/webm MIME type. Exception occured.");
		}
		
	}
	
	@Test
	public void testEquals() throws ParserException {
		MIMEType tmt1 = MIMEType.parse("audio/wav");
		MIMEType tmt2 = MIMEType.parse("video/webm");
		MIMEType tmt3 = MIMEType.parse("audio/wav");
		MIMEType tmt4 = MIMEType.parse("video/webm; codec=vp9");
	
		assertEquals(tmt1, tmt3);
		assertNotEquals(tmt1, tmt2);
		
		assertNotEquals(tmt2, tmt4);
		
	}

}
