//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.swing;

import java.awt.Component;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;



/**
 *
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class JCustomScrollPane extends JScrollPane {

	
	public JCustomScrollPane() {
		super();
	}

	/**
	 * @param vsbPolicy vertical policy
	 * @param hsbPolicy horizontal policy
	 */
	public JCustomScrollPane(int vsbPolicy, int hsbPolicy) {
		super(vsbPolicy, hsbPolicy);
	}

	/**
	 * @param view view
	 */
	public JCustomScrollPane(Component view) {
		super(view);
	}

	/**
	 * @param view view
	 * @param vsbPolicy vertical policy
	 * @param hsbPolicy horizontal policy
	 */
	public JCustomScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
		super(view, vsbPolicy, hsbPolicy);
	}

	public JScrollBar createHorizontalScrollBar(){
		return new JCustomScrollBar(JScrollBar.HORIZONTAL);
	}

}
