package  ipsk.swing.symbols;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;


/**
 * A <code>CharHash</code> is a <code>Hashtable</code> where the key 
 * is the label for a button in the character window and the value is the 
 * tool tip text for this button. In addition to the methods inherited 
 * from <code>Hashtable</code> it provides a method which returns a 
 * sorted <code>Enumeration</code> of the contained keys.
 *
 * @author Simone Leonardi, 
 *  modified Klaus Jaensch: Use Generics for Java 11
 * @version $Revision: 1.2 $
 * 
 */
public class CharHash extends Hashtable<String,String> 
{
    /**
     * Returns an alphabetically sorted <code>Enumeration</code> of the 
     * contained keys. For that purpose the method 
     * <code>Collections.sort(List)</code> is used.
     *
     * @return a sorted <code>Enumeration</code>
     * @see Collections#sort(List)
     */
    public Enumeration<String> sortedKeys()
    {
	Enumeration<String> e = super.keys();
	Vector<String> keys = new Vector<String>();

	// Extract all keys in a vector.
	while( e.hasMoreElements() )
	{
	    keys.addElement(e.nextElement());
	}

	// Sort the vector containing the keys.
	Collections.sort(keys);

	return keys.elements();
    }    
}
