#pragma once
#include <initguid.h>

extern "C" {
JNIEXPORT jobject JNICALL Java_ips_media_jnm_impl_directshow_JAudioRenderer_init(JNIEnv *, jobject);

JNIEXPORT void JNICALL Java_ips_media_jnm_impl_directshow_JaudioRenderer_release(JNIEnv *, jobject,jobject);
}

// {5C898915-4FF7-4090-BBF0-65DC3CAB1827}
DEFINE_GUID(CLSID_JAudioRenderer, 
0x5c898915, 0x4ff7, 0x4090, 0xbb, 0xf0, 0x65, 0xdc, 0x3c, 0xab, 0x18, 0x27);

class DSMediaDecodingPlayer;

class JAudioRenderer :
	public CBaseRenderer
{
private:
	DSMediaDecodingPlayer *mdp;
	JavaVM *javaVm;
	jweak objRef;
	jweak bufferRef;
	jmethodID writeMid;
	JNIEnv* renderEnv;
	volatile DWORD renderThreadID;
public:
	//DECLARE_IUNKNOWN
	static HRESULT CreateInstance(JavaVM* jVm, jweak oRef, jmethodID wMid, LPUNKNOWN pUnk, HRESULT *phr, JAudioRenderer **ppJar);
	JAudioRenderer(JavaVM *jVm,jweak oRef,jmethodID wMid,LPUNKNOWN pUnk,HRESULT *phr);
	HRESULT CheckMediaType(const CMediaType *);
	HRESULT SetMediaType(const CMediaType *);  
	HRESULT Active();
	HRESULT OnStartStreaming();
	HRESULT DoRenderSample(IMediaSample *);
	HRESULT BeginFlush();
	HRESULT OnStopStreaming();
	HRESULT Inactive();
	~JAudioRenderer(void);
};
