#pragma once
#include <initguid.h>
#include <streams.h>
#include <dshow.h>
#include <Wmsdk.h>
#include "DSMediaDecodingPlayer.h"

// {E423124A-8342-4edd-BBC8-A4559455B712}
DEFINE_GUID(CLSID_CJStreamReader, 
0xe423124a, 0x8342, 0x4edd, 0xbb, 0xc8, 0xa4, 0x55, 0x94, 0x55, 0xb7, 0x12);

//static const TCHAR* READER_PIN_NAME="CReaderPin";
static const int MAX_TYPES=13;
static const GUID SUBTYPEGUIDS[MAX_TYPES]={MEDIASUBTYPE_NULL,MEDIASUBTYPE_Avi,MEDIASUBTYPE_MPEG1System,MEDIASUBTYPE_MPEG2_VIDEO,MEDIASUBTYPE_MPEG2_AUDIO,MEDIASUBTYPE_MPEG1Audio,MEDIASUBTYPE_H264,MEDIASUBTYPE_MJPG,MEDIASUBTYPE_QTMovie,MEDIASUBTYPE_Asf,WMMEDIASUBTYPE_WMV1,WMMEDIASUBTYPE_WMV2,WMMEDIASUBTYPE_WMV3};

class CReaderPin : public CBasePin,public IAsyncReader{
private:
	CCritSec *pLock;
CMediaType* mediaTypes[MAX_TYPES];
DSMediaDecodingPlayer *mdp;
bool aSyncReaderIQueried;
//CMediaType *mt;
ULONG refs;
IMemInputPin* memInPin;

void MediaSampleToBuffer(IMediaSample *,LONGLONG *,LONG *,BYTE **);

public:
CReaderPin::CReaderPin(CBaseFilter *,CCritSec *,HRESULT *,DSMediaDecodingPlayer *);
STDMETHODIMP CReaderPin::NonDelegatingQueryInterface(REFIID,void **);

HRESULT STDMETHODCALLTYPE QueryInterface(const IID &,void **);
	ULONG STDMETHODCALLTYPE AddRef();
	ULONG STDMETHODCALLTYPE Release();
HRESULT CReaderPin::CheckMediaType(const CMediaType *);
HRESULT CReaderPin::GetMediaType(int,CMediaType *);
HRESULT CReaderPin::DecideBufferSize(IMemAllocator *,ALLOCATOR_PROPERTIES *);
HRESULT CReaderPin::CheckConnect(IPin *);
STDMETHODIMP CReaderPin::Connect (IPin *,const AM_MEDIA_TYPE *);
STDMETHODIMP CReaderPin::ReceiveConnect (IPin *,const AM_MEDIA_TYPE *);
HRESULT CReaderPin::CompleteConnect(IPin *);
HRESULT CReaderPin::BreakConnect();
HRESULT CReaderPin::GetDeliveryBuffer(IMediaSample **,REFERENCE_TIME *,REFERENCE_TIME *,DWORD);
//HRESULT Deliver(IMediaSample *);
HRESULT STDMETHODCALLTYPE RequestAllocator(IMemAllocator *,ALLOCATOR_PROPERTIES *,IMemAllocator **);
	HRESULT STDMETHODCALLTYPE Request(IMediaSample *,DWORD_PTR);
	HRESULT STDMETHODCALLTYPE WaitForNext(DWORD,IMediaSample **,DWORD_PTR *);
	HRESULT STDMETHODCALLTYPE SyncReadAligned(IMediaSample *);
	HRESULT STDMETHODCALLTYPE SyncRead(LONGLONG,LONG,BYTE *);
	HRESULT STDMETHODCALLTYPE Length(LONGLONG *,LONGLONG *);
HRESULT STDMETHODCALLTYPE BeginFlush(void);
HRESULT STDMETHODCALLTYPE EndFlush(void);

CReaderPin::~CReaderPin(void);
};

class CJStreamReader :
	public CBaseFilter
{
private:
	DSMediaDecodingPlayer *mdp;
	ULONG refs;
	CReaderPin *outPin;
public:
	CJStreamReader(LPUNKNOWN pUnk,HRESULT *phr,CCritSec*,DSMediaDecodingPlayer *);
	int GetPinCount();
	CBasePin* GetPin(int n);
	~CJStreamReader(void);
};
