package ips.media.jnm.impl.directshow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;

import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;

import javax.sound.sampled.Mixer.Info;

import ips.media.MediaDecodingPlayer;
import ips.media.NativeMediaResult;
import ips.media.NativeMediaResult.Type;
import ips.media.NativeMediaSystemException;
import ips.media.control.MediaControlListener;
import ips.media.event.MediaCloseEvent;
import ips.media.event.MediaControlEventTransferAgent;
import ips.media.event.MediaDurationAvailableEvent;
import ips.media.event.MediaEndEvent;
import ips.media.event.MediaOpenEvent;
import ips.media.event.MediaStartedEvent;
import ips.media.event.MediaStoppedEvent;
import ips.media.io.StreamSource;
import ips.media.video.NativeWindowHandle;
import ips.media.video.NativeWindowHandleLong;
import ips.media.video.NativeWindowHandlePointer;
import ips.media.video.VideoFormat;
import ips.media.video.VideoTrackListener;

public class DSMediaDecodingPlayer implements MediaDecodingPlayer, Runnable, ComponentListener, HierarchyListener {
	
	public static final boolean DEBUG=false;

	public static final boolean VIDEO_ENABLED=false;
	
	private ConcurrentLinkedQueue<AsyncReadRequest> bufferFillRequests = new ConcurrentLinkedQueue<AsyncReadRequest>();

	private volatile AsyncReadRequest currentRequest = null;
	private volatile boolean open=false;
	
	private Thread thread;
	private volatile boolean running;

	private ByteBuffer nativePointer;

	private File mediaFile;

	private VideoFormat videoFormat;

	public native ByteBuffer init();
	public native int getApiLevel();

	public native void buildGraph(ByteBuffer np,boolean nativeVideoRendering) throws NativeMediaSystemException;
	private native void setNativeVideoWindowHandleLong(ByteBuffer np, long nativeWindowHwndLong);
	private native void setNativeVideoWindowHandlePointer(ByteBuffer np, ByteBuffer nativeWindowHwndObj);
	private native void setAWTVideoComponent(ByteBuffer np, Component awtComponent);
	public native NativeMediaResult open(ByteBuffer np, String mediaFilePath) throws NativeMediaSystemException;
	public native void setVideoCanvasSize(ByteBuffer np, int x,int y,int width,int height,boolean scaleSizeLogical);
	public native boolean start(ByteBuffer np);

	public native boolean stop(ByteBuffer np);
	public native void releaseGraph(ByteBuffer np);
	public native void close(ByteBuffer np);
	public native long getDuration(ByteBuffer np);
	public native long getPosition(ByteBuffer np);
	public native boolean rewind(ByteBuffer np);
	public native void release(ByteBuffer np);

	private MediaControlEventTransferAgent mceta;
	// private StreamSource mediaStreamSource;
	private File nativeMediaFile;
	private AsyncReader asyncReader;
	private JAudioRenderer audioRenderer;
	
	private volatile byte[] data;

	public void beginFlush() {
		asyncReader.beginFlush();
	}

	public void endFlush() {
		asyncReader.endFlush();
	}

	public long length() throws IOException {
		return asyncReader.length();
	}

	public boolean isMediaStreamSourceSupported(){
	    return true;
	}
	
	public StreamSource getMediaStreamSource() {
		return asyncReader.getMediaStreamSource();
	}

	public void setMediaStreamSource(StreamSource mediaStreamSource) {
		asyncReader.setMediaStreamSource(mediaStreamSource);
		nativeMediaFile=null;
	}

	public int readSync(long pos, byte[] buf, int len) throws IOException {
		return asyncReader.readSync(pos, buf, len);
	}

	public void request(ByteBuffer nativeIMediaSample, long position,
			ByteBuffer bb, long requestID) {
		asyncReader.request(nativeIMediaSample, position, bb, requestID);
	}

	public AsyncReadRequest waitForNext(long timeout) {
		return asyncReader.waitForNext(timeout);
	}

	public int readSync(long pos, ByteBuffer buf, int len) throws IOException {
		return asyncReader.readSync(pos, buf, len);
	}

	private Vector<MediaControlListener> ctrlListeners = new Vector<MediaControlListener>();
	private Vector<VideoTrackListener> listeners = new Vector<VideoTrackListener>();

	private volatile boolean stopReq;
	private PixelInterleavedSampleModel csm;
	private volatile DataBuffer dataBuf;
	private ComponentColorModel ccm;
	private volatile WritableRaster wr;
	private volatile BufferedImage bi;

	private boolean useJavaSound=false;

	private Component awtVideoComponent=null;
	private NativeWindowHandle videoComponentNativePointer=null;

	private boolean scaleSizeLogical;

	private boolean silent;
	
	private boolean builtGraph=false;

	public DSMediaDecodingPlayer() {
		super();
		mceta = new MediaControlEventTransferAgent();

		nativePointer = init();
		if (DEBUG)System.out.println("Native API level: "+getApiLevel());
		asyncReader = new AsyncReader();
		String jVers=System.getProperty("java.version");
		if(DEBUG)System.out.println("java.version: "+jVers);
//		scaleSizeLogical = "9-ea".equals(jVers);
		scaleSizeLogical=("1.8.0_77".compareToIgnoreCase(jVers) <=0);
	}

	public byte[] setVideoFormat(int bits,long width, long height,boolean hasAlpha) {
		int[] bandOffsets;
		int bytes=bits/8;
		if(bits==24){
			bandOffsets=new int[]{2,1,0};
		}else if(bits==32){
			if(hasAlpha){
				bandOffsets=new int[]{2,1,0,3};
			}else{
				bandOffsets=new int[]{2,1,0};
			}
		}else{
			return null;
		}
		boolean linesBottomUp=false;
		if(height>=0){
			// DirectShow indicates page line orientation by sign of height:
			// height>0 : bottom -> up
			// height<0 : top -> down
			linesBottomUp=true;
		}else{
			// use positive height 
			height=-height;
		}
		Dimension videoSize = new Dimension((int)width, (int)height);
		videoFormat = new VideoFormat(bytes,bandOffsets,hasAlpha,linesBottomUp,(int)width,(int)height);
		int imgBufsize=(int)(width* height * bytes);
		data=new byte[imgBufsize];
		if(imgBufsize>0){
			csm = new PixelInterleavedSampleModel(
					DataBuffer.TYPE_BYTE, videoSize.width, videoSize.height, bytes,
					videoSize.width * bytes, bandOffsets);
			dataBuf = new DataBufferByte(data, videoSize.width
					* videoSize.height * bytes);
			//boolean hasAlpha=(bytes==4);

			ccm = new ComponentColorModel(
					ColorSpace.getInstance(ColorSpace.CS_sRGB),
					// ColorSpace.getInstance(ColorSpace.CS_LINEAR_RGB),
					hasAlpha, false, Transparency.TRANSLUCENT, DataBuffer.TYPE_BYTE);
			wr = Raster.createWritableRaster(csm, dataBuf,
					new Point(0, 0));
			bi = new BufferedImage(ccm, wr, false, null);
		}
		for (VideoTrackListener vtl : listeners) {
			// Only set the format if we are in java rendering mode
			// fixes speechrecorder problems with not initialized speaker display 
			if(awtVideoComponent==null){
				vtl.setVideoFormat(videoFormat);
			}
		}
		return data;
	}

	private WritableRaster upsideDown(Raster r) {
		WritableRaster upR = r.createCompatibleWritableRaster();
		int w = r.getWidth();
		int h = r.getHeight();
		int bx = r.getMinX();
		int by = r.getMinY();
		byte[] lineData = null;
		for (int l = 0; l < h; l++) {
			lineData = (byte[]) r.getDataElements(bx, by + h - l - 1, w,
					1, lineData);
			upR.setDataElements(bx, by + l, w, 1, lineData);
		}
		return upR;
	}

	public void render(byte[] data) {
		if (data != null) {

						
			// DataBuffer dataBuf2 = new
			// DataBufferByte(videoSize.width*videoSize.height*3);
			
//		WritableRaster wr2 = upsideDown(wr);

			// //WritableRaster wr2 =
			// Raster.createWritableRaster(csm,dataBuf2,new Point(0,0));
			// AffineTransform flipTransform=new AffineTransform();
			// //flipTransform.quadrantRotate(2);
			// AffineTransformOp flipOp=new AffineTransformOp(flipTransform, new
			// RenderingHints(null));
			// WritableRaster wr=flipOp.filter(wrOrg, null);
			//
			//
			// Bild verkehrt rum !!

			// WritableRaster wr=wrOrg;
//			byte [] d=new byte[data.length];
//			byte[] d=Arrays.copyOf(data, data.length);
			
			
//			Dimension videoSize=videoFormat.getSize();
//			DataBuffer dataBuf = new DataBufferByte(data, videoSize.width
//				* videoSize.height * videoFormat.getPixelStride());
//			WritableRaster wr = Raster.createWritableRaster(csm, dataBuf,
//				new Point(0, 0));
//			BufferedImage bi = new BufferedImage(ccm, wr, false, null);
//			
//			bi.setData(wr);
//			

			// AffineTransform flipTransform=new AffineTransform();
			// flipTransform.rotate(Math.PI);
			// AffineTransformOp flipOp=new AffineTransformOp(flipTransform,
			// AffineTransformOp.TYPE_BILINEAR);
			// BufferedImage biUpsidedown=flipOp.filter(bi, null);
			for (VideoTrackListener vtl : listeners) {
//				vtl.decodedVideoFrame(bi);
				vtl.decodedVideoFrame(data);
			}
		}

}

	/**
	 * Add video track listener.
	 * 
	 * @param vtl
	 *            video track listener
	 */
	public void addVideoTrackListener(VideoTrackListener vtl) {

		synchronized (listeners) {
			if (vtl != null && !listeners.contains(vtl)) {
				listeners.addElement(vtl);
			}
		}
	}

	/**
	 * Remove video track listener.
	 * 
	 * @param vtl
	 *            video track listener
	 */
	public synchronized void removeVideoTrackListener(VideoTrackListener vtl) {
		if (vtl != null) {
			listeners.removeElement(vtl);
		}
	}

	protected void finalize() {
	
		release(nativePointer);

	}

	private native void setAudioRenderer(ByteBuffer np,ByteBuffer jarNp);
	
	public NativeMediaResult open() throws NativeMediaSystemException {
		NativeMediaResult res=new NativeMediaResult(Type.SUCCESS);
		if(useJavaSound){
			if(audioRenderer==null){
				audioRenderer=new JAudioRenderer();
				audioRenderer.setEnabled(!silent);
			}
			setAudioRenderer(nativePointer, audioRenderer.nativePointer());
			
		}
		// Some DirectShow filters cannot be reused, so we build a new graph for every video
		buildGraph(nativePointer,(awtVideoComponent!=null || videoComponentNativePointer!=null));
		if(videoComponentNativePointer!=null){
			_setVideoComponentNativeWindowHandle(videoComponentNativePointer);
		}else if(awtVideoComponent!=null){
			trySetAwtVideoComponent();
		}
		
		// Java 9 ea: Overlay window needs to be scaled logical, but only for width and height!
		// 
		
		if(videoComponentNativePointer!=null){
			setVideoCanvasSize(nativePointer,0,0,800,400,scaleSizeLogical);
		}else if(awtVideoComponent!=null){
			Dimension s=awtVideoComponent.getSize();
			// AWT needs not to be resized (for Java 8 ?)
			setVideoCanvasSize(nativePointer, 0,0,s.width, s.height,false);
			
		}
		running = true;
		thread = new Thread(this);
		thread.start();
		
//		try {
//			asyncReader.open();
//		} catch (IOException e) {
//			throw new NativeMediaSystemException(e);
//		}
		String mediaFilePath=null;
		if(nativeMediaFile!=null){
			mediaFilePath=nativeMediaFile.getAbsolutePath();
		}
		try{
			NativeMediaResult nRes=open(nativePointer,mediaFilePath);
			if(nRes!=null){
				res=nRes;
			}
		}catch(NativeMediaSystemException nme){
			// Workaround: Fixes bug:
			// load big_buck_bunny_1080 (can not be played)  ->fails with exception
			// load big_buck_bunny_720 (can be played) 
			// crashes here (why ??)
			// hr=pGraph->AddFilter(jar,L"JavaAudioRenderer");
			// if audiorenderer is not reset to null here
			
			_close();
			throw nme;
		}
		open=true;
		mceta.fireEvent(new MediaOpenEvent(this));
		long durationNs=getDuration(nativePointer)*100;
		MediaDurationAvailableEvent mdae=new MediaDurationAvailableEvent(this, durationNs);
		mceta.fireEvent(mdae);
		return res;
	}

	public void start() {
		if (open && start(nativePointer)) {
		    //System.err.println(" DSMediadecodingPlayer Media player started "+silent);
			mceta.fireEvent(new MediaStartedEvent(this));
		}else{
		    //System.err.println(" DSMediadecodingPlayer Media player NOT started! "+silent);
		}
	}

	public void stop() {
		if (stop(nativePointer)) {
		    //System.err.println(" DSMediadecodingPlayer Media player stopped! "+silent);
			mceta.fireEvent(new MediaStoppedEvent(this));
		}else{
		    //System.err.println(" DSMediadecodingPlayer Media player NOT stopped! "+silent);
		 // TEST always fire event
	        //mceta.fireEvent(new MediaStoppedEvent(this));
		}
		
	}
	
	private void _close(){
		running=false;
		//System.out.println("DSMediadecodingPlayer _close()"+silent);
		if(thread!=null){
			// terminate event wait loop
			thread.interrupt();
			//System.out.println("DSMediadecodingPlayer _close() thread interr "+silent);
			// The interrupt call does not interrupt
			// The WaitForSingleObject native call
			try {
				thread.join();
			} catch (InterruptedException e) {
				
			}
			//System.out.println("DSMediadecodingPlayer _close() thread joined "+silent);
		}
		/// now it should be safe to close and release the graph
		open=false; // TODO correct state would be CLOSING, but this prevents
		            // calls to setVideoCanvasSize
		close(nativePointer);
		releaseGraph(nativePointer);
		//System.out.println("DSMediadecodingPlayer _close() native closed "+silent);
		audioRenderer=null;
	}

	public void close() {
		if(!open){
			return;
		}
		//System.out.println("DSMediadecodingPlayer close() "+silent);
		_close();
		mceta.fireEvent(new MediaCloseEvent(this));
		//System.out.println("DSMediadecodingPlayer close() event fired "+silent);
	}

	public native void waitForEvent(ByteBuffer nativeP);

	public void run() {
		while (running) {
			waitForEvent(nativePointer);
		}
	}

	public void pause() {
		// TODO Auto-generated method stub

	}
	
	public void endOfStream(){
	    //System.out.println("DSMediadecodingPlayer endofstream() "+silent);
		mceta.fireEvent(new MediaEndEvent(this));
	}

	public void addMediaControlListener(
			MediaControlListener mediaControlListener) {
		mceta.addListener(mediaControlListener);

	}

	public void removeMediaControlListener(
			MediaControlListener mediaControlListener) {
		mceta.removeListener(mediaControlListener);
	}

	public void rewind() {
		if(open){
			rewind(nativePointer);
		}
	}

	public void setNativeMediaFile(File mediaFile) {
		this.nativeMediaFile=mediaFile;
		asyncReader.setMediaStreamSource(null);
	}

	public void stepForward() {
		// TODO Auto-generated method stub
		
	}


    public boolean isNativeVideoComponentRenderingSupported() {
        return true;
    }
    
    private void trySetAwtVideoComponent(){
    	if(awtVideoComponent!=null && awtVideoComponent.isDisplayable()){
    		if(DEBUG)System.out.println(Integer.toHexString(hashCode())+" AWT component displayable !!");
    		setAWTVideoComponent(nativePointer,awtVideoComponent);
    	}
    }

    public void setAWTVideoComponent(Component videoCanvas)
            throws NativeMediaSystemException {
    	if(videoCanvas.isDisplayable() && videoCanvas.isLightweight()){
            throw new NativeMediaSystemException("Lightweight (Swing) components not supported! Please use AWT Canvas.");
        }
    	this.videoComponentNativePointer=null;
    	// AWT needs not to be resized (for Java 8 ?) and it does not work yet
    	scaleSizeLogical=false;
        this.awtVideoComponent = videoCanvas;
        this.awtVideoComponent.addComponentListener(this);
        this.awtVideoComponent.addHierarchyListener(this);
        trySetAwtVideoComponent();
    }
   

//    public void setVideoComponentNativePointer(long videoCompNativePointer)
//            throws NativeMediaSystemException {
//        this.awtVideoComponent = null;
//        System.out.println("HWND java :"+videoCompNativePointer);
//        this.videoComponentNativePointer=videoCompNativePointer;
//    }
    public boolean isJavaSoundSupported() {
        return true;
    }

    public void setUseJavaSound(boolean useJavaSound) {
      this.useJavaSound=useJavaSound;
    }
    
    public void setSilent(boolean silent){
    	this.silent=silent;
    }

    public void setAudioDeviceInfo(Info audioDeviceInfo) {
    	// TODO
        // not supported
        
    }

	public void componentHidden(ComponentEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void componentMoved(ComponentEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
	

	public void componentResized(ComponentEvent arg0) {
		if(open){
		Dimension s=awtVideoComponent.getSize();
		setVideoCanvasSize(nativePointer, 0,0,s.width, s.height,scaleSizeLogical);
		}
	}

	public void componentShown(ComponentEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	//@Override
	public long getPositionNs() {
		return getPosition(nativePointer)*100;
	}

	//@Override
	public void setNativeVideoCanvasSize(double width, double height) {
		if(open){
			setVideoCanvasSize(nativePointer,0,0,(int)width,(int)height,scaleSizeLogical);
		}
	}
	//@Override
	public boolean isOpen() {
		return open;
	}
	//@Override
	public boolean isRunning() {
		return running;
	}
	//@Override
	public void hierarchyChanged(HierarchyEvent arg0) {
		trySetAwtVideoComponent();
	}
	 //@Override
	 public void setVideoComponentNativeWindowHandle(NativeWindowHandle nativeWindowHandle)
	            throws NativeMediaSystemException {
		this.awtVideoComponent = null;
	    this.videoComponentNativePointer=nativeWindowHandle;
	    _setVideoComponentNativeWindowHandle(videoComponentNativePointer);
	 }
    
    private void _setVideoComponentNativeWindowHandle(NativeWindowHandle nativeWindowHandle)
            throws NativeMediaSystemException {
    	
    	if(nativeWindowHandle instanceof NativeWindowHandleLong){
    		NativeWindowHandleLong pwh=(NativeWindowHandleLong)nativeWindowHandle;
    		long lh=pwh.getHandle();
    		setNativeVideoWindowHandleLong(nativePointer,lh);
    	}else if(nativeWindowHandle instanceof NativeWindowHandlePointer){
    		NativeWindowHandlePointer nwhp=(NativeWindowHandlePointer)nativeWindowHandle;
    		ByteBuffer p=nwhp.getPointer();
    		setNativeVideoWindowHandlePointer(nativePointer, p);
    	}

    }
    //@Override
    public boolean requiresDisplayableToRun() {
        return false;
    }


}
