package ips.media.jnm.impl.directshow;

import java.nio.ByteBuffer;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

import ips.media.event.MediaControlEventTransferAgent;


// TODO not used yet
public class JAudioRenderer {

	private static final boolean DEBUG=false;

	private MediaControlEventTransferAgent mceta;
	
	private Mixer.Info audioDeviceInfo;
//	private SourceDataLine sourceDataLine;
	private SourceDataLine sdl;
	
	private long audioFramePositionSync=0;
	private volatile long audioBytesWritten;
	private boolean videosinkSet=false; 
	
	private boolean useJavaSound=false;
	

	private ByteBuffer nativePointer;

	private native ByteBuffer init();
	private native void release(ByteBuffer nativePointer);
	    
	private volatile long audioFramePosition; 
	private volatile long audioTimeSync=-1;
	private Long audioStart=null;
	private int bufferSize;
	private int fakeBufFilled;
	private Long lastFakeBufferUpdate=null;
	private float frameRate;
	private boolean enabled=true;
	public boolean isEnabled() {
		return enabled;
	}
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	private boolean active=false;



	private AudioFormat audioFormat;

	public JAudioRenderer() {
	    super();
	    nativePointer=init();
	}
	
	// called from native CBaseRenderer::SetMediaType(const CMediaType *)
	public void setAudioFormat(int sampleRate,int bitsPerSample,int channels){
		int sampleSizeInBits=bitsPerSample;
		audioFormat = new AudioFormat(sampleRate, sampleSizeInBits, channels, true, false);
		if(DEBUG){
			System.out.println("Audio format (Java): "+audioFormat);
		}
//		return true;
	}
	// called from native CBaseRenderer::Active()
	public boolean open(){
	    if(DEBUG){
	        System.out.println("Audio open");
	    }
		audioBytesWritten=0;
		audioFramePosition=0;
		audioFramePositionSync=0;
		if(!enabled){
//		    bufferSize=bufSize;
		    fakeBufFilled=0;
		    lastFakeBufferUpdate=null;
		    frameRate=audioFormat.getFrameRate();
		    active=true;
		    return true;
		}
		if(audioDeviceInfo==null){
		    try {
                sdl=AudioSystem.getSourceDataLine(audioFormat);
            } catch (LineUnavailableException e) {
               return false;
            }
		}else{
		    try {
                AudioSystem.getSourceDataLine(audioFormat, audioDeviceInfo);
            } catch (LineUnavailableException e) {
               return false;
            }
		}
		if(sdl==null){
		    return false;
		}
		
			try {
			   
				if(DEBUG)System.out.println("Audio "+audioFormat);
				sdl.open(audioFormat);
				bufferSize=sdl.getBufferSize();
				if(DEBUG)System.out.println("Buffer size "+bufferSize+" "+bufferSize/(audioFormat.getFrameSize()*audioFormat.getSampleRate()));
				
				 return true;
			} catch (LineUnavailableException e) {
				
				return false;
			}
		
	}
	// called from native CBaseRenderer::OnStartStreaming()
	public void start(){
	 if(enabled && !sdl.isActive()){
         sdl.start();
         if(DEBUG)System.out.println("SDL started");
   }
	}
	// called from native CBaseRenderer::OnStopStreaming()
	public void stop(){
		if(enabled){
//		 if(sdl.isActive()){
	         sdl.stop();
	         if(DEBUG)System.out.println("SDL stopped");
//	   }
		}
		}
	
	private void updateFakeBuffer(){
	    if(lastFakeBufferUpdate==null){
	        lastFakeBufferUpdate=System.currentTimeMillis();
	    }
	    long bufPlayedTime=System.currentTimeMillis()-lastFakeBufferUpdate;
	    int bytesPlayed=(int)(frameRate*bufPlayedTime/1000);
	    int newFbf=fakeBufFilled-bytesPlayed;
	    if(newFbf<0){
	        newFbf=0;
	    }
	    fakeBufFilled=newFbf;
	    lastFakeBufferUpdate=System.currentTimeMillis();
	}
	
	// called from native CBaseRenderer::DoRenderSample(IMediaSample *)
	public int audioWrite(byte[] buf){
		if (DEBUG)System.out.println("Audio write "+buf.length+" bytes.");

		int written=0;
		if(enabled){
			written=sdl.write(buf, 0, buf.length);
		}else{
			if(audioStart==null){
				audioStart=System.currentTimeMillis();
			}
			return buf.length;
		}
		audioBytesWritten+=written;

		if(DEBUG)System.out.println("Audio written "+written+" bytes");
		return written;
	}
	
	public int audioDelay(){

		AudioFormat af=sdl.getFormat();
		int frameSize=af.getFrameSize();
		int delay;
		long retFramePos;
		if(enabled){
			long framePos=sdl.getLongFramePosition();
			retFramePos=framePos-audioFramePositionSync;
		}else{
			if(audioStart==null){
				retFramePos=0;
			}else{
				float frameRate=af.getFrameRate();
				long playTime=System.currentTimeMillis()-audioStart;
				retFramePos=(long)(playTime*frameRate/1000);
			}
		}
		delay=(int) (audioBytesWritten/frameSize -retFramePos);
		if(DEBUG) System.out.println("Delay: "+delay);
		return delay;
	}
	
	public void audioReset(){
		if(DEBUG)System.out.println("Audio reset...");

		if(!enabled){
			audioStart=null;
			active=false;
		}else{
			if(sdl!=null){
				sdl.stop();
				sdl.flush();
				if(DEBUG)System.out.println("Audio flushed.");
				// sync
				audioFramePositionSync=sdl.getLongFramePosition();
				audioBytesWritten=0;
				sdl.start();
				if(DEBUG)System.out.println("Audio restarted.");
			}
		}
	}
	
	public boolean audioUnprepare(){
	    return  true;
	}
	
	// called from native CBaseRenderer::Inactive
	public void close(){
		if(DEBUG)System.out.println("Audio close...");
		if(enabled && sdl!=null){
			sdl.stop();
			sdl.close();
		}else{
			if(DEBUG)System.out.println("Fake silent audio close...");
		}
		audioStart=null;
		active=false;
		audioBytesWritten=0;
		audioFramePositionSync=0;
		if(DEBUG)System.out.println("Audio closed.");
	
	}

	protected void finalize() {
		release(nativePointer);
		if (DEBUG)System.out.println("audio sink finalized");
	}



  



    public Mixer.Info getAudioDeviceInfo() {
        return audioDeviceInfo;
    }

    public void setAudioDeviceInfo(Mixer.Info audioDeviceInfo) {
        this.audioDeviceInfo = audioDeviceInfo;
    }
    public ByteBuffer nativePointer() {
      
        return nativePointer;
    }


}
