/*
 * Date  : Dec 19, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ips.prompting.media;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import javax.sound.sampled.Mixer;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

import ips.media.MediaDecodingPlayer;
import ips.media.NativeMediaPartialRenderResult;
import ips.media.NativeMediaResult;
import ips.media.NativeMediaSystemException;
import ips.media.NativeMediaSystemsManager;
import ips.media.control.MediaControlListener;
import ips.media.event.MediaCloseEvent;
import ips.media.event.MediaEndEvent;
import ips.media.event.MediaErrorEvent;
import ips.media.event.MediaEvent;
import ips.media.event.MediaOpenEvent;
import ips.media.event.MediaStartedEvent;
import ips.media.event.MediaStoppedEvent;
import ips.media.spi.NativeMediaSystem;
import ips.media.video.JVideoPanel;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.StartPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.StopPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterOpenedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStartEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import ipsk.net.URLContext;
import ipsk.util.services.ServiceDescriptorProvider;


/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 */

public class NativeMediaPromptPresenter extends BasicPromptPresenter implements
		ServiceDescriptorProvider<PromptPresenterServiceDescriptor>,
		MediaPromptPresenter, MediaControlListener, AncestorListener {

	private final static boolean DEBUG = false;

	// private JMediaPlayer mediaPlayer;
	// private JVideoComponent videoComponent;
	private MediaDecodingPlayer mediaPlayer;
	private JVideoPanel videoComponent;
	private Action startControlAction=null;
	private Action stopControlAction=null;
	private boolean silent=false;
	public boolean isSilent() {
		return silent;
	}

	private boolean running = false;
	private boolean useAWT = false;

	public PromptPresenterServiceDescriptor getServiceDescriptor() {
		return new NativeMediaPromptPresenterServiceDescriptor();
	}
	
	
	private void reval(){
//		revalidate();
//		videoComponent.revalidate();
//		videoComponent.getAwtVideoComponent().revalidate();
//		// ... and just in case, call validate() on the top-level window as well
//
//		Window window = SwingUtilities.getWindowAncestor(videoComponent.getAwtVideoComponent());
//		if (window != null) {
//			window.validate();
//			System.out.println("Window validated: "+window);
//		}
//		window = SwingUtilities.getWindowAncestor(videoComponent);
//		if (window != null) {
//			window.validate();
//			System.out.println("Window validated: "+window);
//		}
//		
//		window = SwingUtilities.getWindowAncestor(this);
//		if (window != null) {
//			window.validate();
//			// System.out.println("Window validated");
//		}
	}

	public void addNotify() {
		// System.out.println("AddNotify");
		super.addNotify();
		reval();
	}

	public void removeNotify() {
		// System.out.println("removeNotify");
		// if(useAWT){
		// // native AWT Canvas (X11 window) crashes if not connected to X11
		// peer
		// // so stop it here
		// mediaPlayer.stop();
		// }
		super.removeNotify();
	}

	public NativeMediaPromptPresenter() throws PromptPresenterPluginException{
		super();
		NativeMediaSystem nms;
		try {
			nms = NativeMediaSystemsManager.createDefaultNativeMediaSystem();
			if (DEBUG)
				System.out.println("Using native media system: "
						+ nms.getTitle().localize());
			if (nms == null) {
			    String msg="Could not instantiate native media system";
				System.err
						.println(msg);
				throw new PromptPresenterPluginException(msg);
				
			}else{
				nms.initialize();
			}
			mediaPlayer = nms.createMediaDecodingPlayer();
		} catch (NativeMediaSystemException e) {
			
			e.printStackTrace();
			throw new PromptPresenterPluginException(e);
		}

		videoComponent = new JVideoPanel();

		if (mediaPlayer.isNativeVideoComponentRenderingSupported()) {
			try {
				mediaPlayer.setAWTVideoComponent(videoComponent
						.getAwtVideoComponent());
				useAWT = true;
			} catch (NativeMediaSystemException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		mediaPlayer.setUseJavaSound(true);
		mediaPlayer.setSilent(silent);

		mediaPlayer.addMediaControlListener(this);
		setLayout(new BorderLayout());

		add(videoComponent, BorderLayout.CENTER);
		
		// }
		addAncestorListener(this);
		mediaPlayer.addVideoTrackListener(videoComponent);
		// videoComponent.setPreferredSize(new Dimension(500, 500));
		
		
		videoComponent.addVideoMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
//				if(mediaPlayer.isOpen()){
				
					if(mediaPlayer.isRunning()){
						if(stopControlAction!=null && stopControlAction.isEnabled()){
							ActionEvent stopPromptEvent=new ActionEvent(this, e.getID(),StopPromptPlaybackAction.ACTION_COMMAND);
							stopControlAction.actionPerformed(stopPromptEvent);
						}
					}else{
						if(startControlAction!=null && startControlAction.isEnabled()){
							ActionEvent startPromptEvent=new ActionEvent(this, e.getID(),StartPromptPlaybackAction.ACTION_COMMAND);
							startControlAction.actionPerformed(startPromptEvent);
						}
					}
//				}
			}
		});
	}

	public void update(MediaEvent mediaEvent) {
		if (mediaEvent instanceof MediaOpenEvent) {
//			startControlAction.setEnabled(true);
//			stopControlAction.setEnabled(false);
			PromptPresenterOpenedEvent ppev = new PromptPresenterOpenedEvent(
					this);
			updateListeners(ppev);
		} else if (mediaEvent instanceof MediaStartedEvent) {
			running = true;
//			startControlAction.setEnabled(false);
//			stopControlAction.setEnabled(true);
			if(DEBUG)System.out.println("PP start ev "+silent);
			PromptPresenterStartEvent ppev = new PromptPresenterStartEvent(this);
			updateListeners(ppev);
		} else if (mediaEvent instanceof MediaStoppedEvent) {
			running = false;
			if(DEBUG)System.out.println("PP stopped ev "+silent);
//			startControlAction.setEnabled(true);
//			stopControlAction.setEnabled(false);
			PromptPresenterStopEvent ppev = new PromptPresenterStopEvent(this);
			updateListeners(ppev);
		} else if (mediaEvent instanceof MediaEndEvent) {
			running = false;
//			startControlAction.setEnabled(true);
//			stopControlAction.setEnabled(false);
			if(DEBUG)System.out.println("PP stop end ev "+silent);
			
			PromptPresenterStopEvent ppev = new PromptPresenterStopEvent(this);
			updateListeners(ppev);
		} else if (mediaEvent instanceof MediaErrorEvent) {
			running = false;
			if(DEBUG)System.out.println("PP err ev "+silent);
//			startControlAction.setEnabled(false);
//			stopControlAction.setEnabled(false);
			PromptPresenterClosedEvent ppev = new PromptPresenterClosedEvent(
					this);
			updateListeners(ppev);
		} else if (mediaEvent instanceof MediaCloseEvent) {
			running = false;
			if(DEBUG)System.out.println("PP close ev "+silent);
//			startControlAction.setEnabled(true);
//			stopControlAction.setEnabled(false);
			PromptPresenterClosedEvent ppev = new PromptPresenterClosedEvent(
					this);
			updateListeners(ppev);
		}
	}

	public void loadContents() throws PromptPresenterException {
		URI muri = mediaitems[0].getSrc();
		try {
			URL murl = URLContext.getContextURL(contextURL, muri.toString());
			String p = murl.getPath();
			File mFile = new File(p);
			mediaPlayer.setNativeMediaFile(mFile);
		} catch (MalformedURLException e) {
			throw new PromptPresenterException(e);
		}

	}

	public void setAudioMixer(Mixer mixer)
			throws PromptPresenterPluginException {
		// TODO Auto-generated method stub

	}

	public void setSilent(boolean silent) {
		this.silent = silent;
		mediaPlayer.setSilent(silent);

	}
	
	public void setStartControlAction(Action startControlAction) {
		this.startControlAction=startControlAction;
		
	}

	public void setStopControlAction(Action stopControlAction) {
		this.stopControlAction=stopControlAction;
	}

	public void open() throws PromptPresenterException {
		// if(silent){
		// PromptPresenterOpenedEvent ppev=new PromptPresenterOpenedEvent(this);
		// updateListeners(ppev);
		// }else{

		// videoComponent.setVisible(true);
		videoComponent.setEnabled(true);
		//

		// videoComponent.getAwtVideoComponent().repaint();
		try {

			NativeMediaResult res=mediaPlayer.open();
			if(res instanceof NativeMediaPartialRenderResult){
				// Treat partial rendering warnings for ProjectManager as exception (error)
				// Occurs for example if only audio can be played but not video
				throw new NativeMediaSystemException("Cannot playback prompt media: "+res.getMessage());
			}
		} catch (NativeMediaSystemException e) {
			throw new PromptPresenterException(e);
		}
		// All workarounds do not help
		// The Swing top down menu is sometimes hidden by the AWT canvas 
		
//		videoComponent.revalidate();
		// ... and just in case, call validate() on the top-level window as well

//		Window window = SwingUtilities.getWindowAncestor(videoComponent);
//		if (window != null) {
//			window.validate();
//			// System.out.println("Window validated");
//		}
	}

	public void start() throws PromptPresenterException {

		// if(silent){
		// PromptPresenterStartEvent ppev1=new PromptPresenterStartEvent(this);
		// updateListeners(ppev1);
		// EventQueue.invokeLater(new Runnable(){
		// public void run(){
		//
		// stop();
		// }
		// });
		// }else{
		if (!running) {
			mediaPlayer.start();
		}
		// }

	}

	public void stop() {
		// if(silent){
		// updateListeners(new PromptPresenterStopEvent(this));
		// }else{
		mediaPlayer.stop();
		// }
	}

	public void close() throws PromptPresenterException {
		// if(silent){
		// PromptPresenterClosedEvent ppev=new PromptPresenterClosedEvent(this);
		//
		// updateListeners(ppev);
		// }else{
		mediaPlayer.close();
		// }
	}

	public void ancestorAdded(AncestorEvent event) {
		// TODO Auto-generated method stub
		reval();
	}

	public void ancestorRemoved(AncestorEvent event) {
		// TODO Auto-generated method stub
		reval();
	}

	public void ancestorMoved(AncestorEvent event) {
		// TODO Auto-generated method stub
		reval();
	}


    public boolean requiresDisplayableToRun() {
        return false;
    }

}
