package ips.media.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileStreamSource implements StreamSource {

	private File file;
	private RandomAccessFile randomAccessFile;
	public FileStreamSource(File file){
		super();
		this.file=file;
	}
	public void open() throws IOException {
		randomAccessFile=new RandomAccessFile(file,"r");
	}

	public void seek(long pos) throws IOException {
		//System.out.println("Seek: "+pos);
		randomAccessFile.seek(pos);
	}

	public int read(byte[] buf, int off, int len) throws IOException {
	//	System.out.println("read "+len+" bytes");
		return randomAccessFile.read(buf,off,len);
	}

	public void close() throws IOException {
		randomAccessFile.close();
	}
	public long length() throws IOException {
		return randomAccessFile.length();
	}

}
